/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diagnostics.internal.platform.monitor.operatingsystem.cpu;

import java.lang.management.ManagementFactory;
import javax.annotation.Nonnull;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class CPUDiagnostic {
    private static final String OPERATING_SYSTEM = "java.lang:type=OperatingSystem";

    double getCpuUsage() {
        try {
            Object systemCpuUsageAttributeValue = ManagementFactory.getPlatformMBeanServer().getAttribute(this.getOperatingSystemObjectName(), "SystemCpuLoad");
            if (systemCpuUsageAttributeValue == null) {
                return 0.0;
            }
            return (Double)systemCpuUsageAttributeValue >= 0.0 ? (Double)systemCpuUsageAttributeValue * 100.0 : 0.0;
        }
        catch (JMException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Nonnull
    private ObjectName getOperatingSystemObjectName() throws MalformedObjectNameException {
        return new ObjectName(OPERATING_SYSTEM);
    }
}

