package com.atlassian.diagnostics.internal.platform.analytics.ram;

import javax.annotation.Nonnull;

public class LowRamAnalyticsEvent {

    private final Long freeMemoryInMb;
    private final Long totalMemoryInMb;
    private final Long minMemoryThresholdInMb;

    protected LowRamAnalyticsEvent(@Nonnull final Long freeMemoryInMegabytes,
                                   @Nonnull final Long totalMemoryInMegabytes,
                                   @Nonnull final Long minMemoryThresholdInMegabytes) {
        this.freeMemoryInMb = freeMemoryInMegabytes;
        this.totalMemoryInMb = totalMemoryInMegabytes;
        this.minMemoryThresholdInMb = minMemoryThresholdInMegabytes;
    }

    public Long getFreeMemoryInMb() {
        return freeMemoryInMb;
    }

    public Long getTotalMemoryInMb() {
        return totalMemoryInMb;
    }

    public Long getMinMemoryThresholdInMb() {
        return minMemoryThresholdInMb;
    }
}
