package com.atlassian.diagnostics.internal.platform.monitor.gc;

import java.lang.management.GarbageCollectorMXBean;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;

class GCMXBeanPoller {
    private final GarbageCollectorMXBean garbageCollectorMXBean;
    private final Clock clock;

    public GCMXBeanPoller(final GarbageCollectorMXBean garbageCollectorMXBean,
                          final Clock clock) {
        this.garbageCollectorMXBean = garbageCollectorMXBean;
        this.clock = clock;
    }

    public GCRead doRead() {
        return GCRead.builder()
                .timestamp(Instant.now(clock))
                .collectionTime(Duration.ofMillis(garbageCollectorMXBean.getCollectionTime()))
                .collectionCount(garbageCollectorMXBean.getCollectionCount())
                .build();
    }

    public String getGarbageCollectorName() {
        return garbageCollectorMXBean.getName();
    }
}
