package com.atlassian.diagnostics.internal.platform.plugin;

import static java.lang.Boolean.FALSE;
import static java.lang.Boolean.parseBoolean;
import static java.lang.Integer.getInteger;
import static java.lang.System.getProperty;

public class DefaultPluginSystemMonitoringConfig implements PluginSystemMonitoringConfig {
    // Left visible for extension by the products
    protected static final String TRAVERSAL_LIMIT_CLASS_CONTEXT_KEY = "atlassian.diagnostics.traversal.limit.class.context";
    protected static final String TRAVERSAL_LIMIT_STACK_TRACE_KEY = "atlassian.diagnostics.traversal.limit.stack.trace";
    protected static final String DISABLE_CLASS_NAME_TO_PLUGIN_KEY = "atlassian.diagnostics.classname.pluginkey.map.disable";
    protected static final int DEFAULT_CLASS_CONTEXT_TRAVERSAL_LIMIT = 10;
    protected static final int DEFAULT_STACK_TRACE_TRAVERSAL_LIMIT = 20;

    @Override
    public boolean classNameToPluginKeyStoreDisabled() {
        return parseBoolean(getProperty(DISABLE_CLASS_NAME_TO_PLUGIN_KEY, FALSE.toString()));
    }

    @Override
    public int classContextTraversalLimit() {
        return getInteger(TRAVERSAL_LIMIT_CLASS_CONTEXT_KEY, DEFAULT_CLASS_CONTEXT_TRAVERSAL_LIMIT);
    }

    @Override
    public int stackTraceTraversalLimit() {
        return getInteger(TRAVERSAL_LIMIT_STACK_TRACE_KEY, DEFAULT_STACK_TRACE_TRAVERSAL_LIMIT);
    }
}
