/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.concurrent;

import com.atlassian.concurrent.GoChanReader;
import com.atlassian.concurrent.GoChanWriter;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class GoChan<T>
implements GoChanReader<T>,
GoChanWriter<T> {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final BlockingQueue<T> q;

    public GoChan() {
        this.q = new SynchronousQueue<T>();
    }

    public GoChan(int capacity) {
        this.q = new LinkedBlockingQueue<T>(capacity);
    }

    @Override
    public void send(T t) throws InterruptedException {
        while (!this.q.offer(t, 1L, TimeUnit.SECONDS)) {
            if (!this.closed.get()) continue;
            throw new IllegalStateException("Attempted to send to a closed channel");
        }
    }

    @Override
    public Optional<T> receive() throws InterruptedException {
        T t;
        while (!this.closed.get()) {
            t = this.q.poll(1L, TimeUnit.SECONDS);
            if (t == null) continue;
            return Optional.of(t);
        }
        t = this.q.poll(0L, TimeUnit.SECONDS);
        if (t != null) {
            return Optional.of(t);
        }
        return Optional.empty();
    }

    @Override
    public void close() {
        this.closed.set(true);
    }

    @Override
    public void forEach(Consumer<? super T> action) throws InterruptedException {
        Optional<T> opt;
        while ((opt = this.receive()).isPresent()) {
            action.accept(opt.get());
        }
    }
}

