/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash;

import com.atlassian.stash.Git;
import com.atlassian.stash.PullRequestBuilder;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitBucketServer {
    static Logger LOG = LoggerFactory.getLogger(BitBucketServer.class);

    public static Builder withGit(Git git) {
        return new Builder().git(git);
    }

    static <T> T cuircutBreaker(int retryCount, Supplier<T> action, Predicate<T> repeatIf) {
        T t;
        int attempts = 0;
        do {
            if (attempts > 0) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            t = action.get();
        } while (++attempts <= retryCount && repeatIf.test(t));
        return t;
    }

    public static class Builder {
        private Git git;
        private String committerName;
        private String committerEmail;
        private String slug;
        private String project;

        private Builder() {
        }

        public Builder git(Git git) {
            this.git = git;
            return this;
        }

        public Builder withUser(String name, String email) {
            this.committerName = name;
            this.committerEmail = email;
            return this;
        }

        public Builder forRepo(String project, String repoSlug) {
            this.project = project;
            this.slug = repoSlug;
            return this;
        }

        public Repo build() {
            return new Repo(this.project, this.slug, this.committerName, this.committerEmail, this.git);
        }
    }

    public static class Repo {
        final String project;
        final String repoSlug;
        final String committerName;
        final String committerEmail;
        final Git git;

        public Repo(String project, String repoSlug, String committerName, String committerEmail, Git git) {
            this.project = project;
            this.repoSlug = repoSlug;
            this.committerName = committerName;
            this.committerEmail = committerEmail;
            this.git = git;
        }

        public void setOriginURL() throws IOException, URISyntaxException {
            LOG.info("staging all files.");
            this.git.remoteAdd("origin", new URI("ssh://git@stash.atlassian.com:7997/" + this.project + "/" + this.repoSlug + ".git"));
        }

        public void pushWorkspace(String branchName) throws IOException {
            LOG.info("staging all files.");
            this.git.addAll();
            LOG.info("committing to local.");
            this.git.commit("@Flaky annotations added.");
            LOG.info("pushing to remote.");
            this.git.push("origin", branchName);
        }

        public PullRequestBuilder openPullRequestFrom(String branchName) {
            return new PullRequestBuilder(this, branchName);
        }
    }
}

