/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash;

import com.atlassian.stash.BitBucketServer;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class PullRequestBuilder {
    private final BitBucketServer.Repo repo;
    private final String branchName;
    private String target;
    private String[] reviewers;
    private String token = null;

    PullRequestBuilder(BitBucketServer.Repo repo, String branchName) {
        this.repo = repo;
        this.branchName = branchName;
        this.target = "master";
        this.reviewers = new String[0];
    }

    public PullRequestBuilder to(String target) {
        this.target = target;
        return this;
    }

    public PullRequestBuilder withReviewers(String ... reviewers) {
        this.reviewers = reviewers;
        return this;
    }

    public PullRequestBuilder withOAuth(String token) {
        this.token = token;
        return this;
    }

    @VisibleForTesting
    public String createPullRequestJson() {
        StringBuilder buf = new StringBuilder();
        buf.append("{\n    \"title\": \"@Flaky\",\n    \"description\": \"Flaky test was detected\",\n    \"state\": \"OPEN\",\n    \"open\": true,\n    \"closed\": false,\n    \"fromRef\": {\n        \"id\": \"refs/heads/" + this.branchName + "\",\n        \"repository\": {\n            \"slug\": \"" + this.repo.repoSlug + "\",\n            \"name\": null,\n            \"project\": {\n                \"key\": \"" + this.repo.project + "\"\n            }\n        }\n    },\n    \"toRef\": {\n        \"id\": \"refs/heads/" + this.target + "\",\n        \"repository\": {\n            \"slug\": \"" + this.repo.repoSlug + "\",\n            \"name\": null,\n            \"project\": {\n                \"key\": \"" + this.repo.project + "\"\n            }\n        }\n    },\n    \"locked\": false,\n    \"reviewers\": [\n");
        buf.append(String.join((CharSequence)",", Arrays.asList(this.reviewers).stream().map(name -> "        {\n            \"user\": {\n                \"name\": \"" + name + "\"\n            }\n        }\n").collect(Collectors.toCollection(() -> new LinkedList()))));
        buf.append("    ]\n}");
        return buf.toString();
    }

    public void perform() {
        try {
            String prURL = "https://stash.atlassian.com/rest/api/1.0/projects/" + this.repo.project + "/repos/" + this.repo.repoSlug + "/pull-requests";
            String json = this.createPullRequestJson();
            HttpResponse finalResponse = BitBucketServer.cuircutBreaker(1, () -> {
                try {
                    CloseableHttpClient client = HttpClients.createDefault();
                    HttpPost request = new HttpPost(prURL);
                    request.setHeader("Authorization", "Bearer " + this.token);
                    request.setHeader("Accept", "application/json");
                    request.setHeader("Content-type", "application/json");
                    request.setEntity((HttpEntity)new StringEntity(json));
                    BitBucketServer.LOG.info("Post PR create.");
                    HttpResponse response = client.execute((HttpUriRequest)request);
                    BitBucketServer.LOG.info("Create PR status: " + response.getStatusLine());
                    HeaderIterator iter = response.headerIterator();
                    while (iter.hasNext()) {
                        Header header = iter.nextHeader();
                        BitBucketServer.LOG.info(header.getName() + " " + header.getValue());
                    }
                    String respString = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                    BitBucketServer.LOG.info("Create PR response: " + respString);
                    return response;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }, response -> response.getStatusLine().getStatusCode() >= 500);
            if (finalResponse.getStatusLine().getStatusCode() >= 400) {
                throw new AuthenticationException(IOUtils.toString((InputStream)finalResponse.getEntity().getContent(), (Charset)StandardCharsets.UTF_8));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

