/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.test.reporting;

import com.atlassian.test.reporting.JUnitFlakyTestConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileReporter {
    private static final Logger log = LoggerFactory.getLogger(FileReporter.class);
    private final JUnitFlakyTestConfiguration configuration;

    public FileReporter(JUnitFlakyTestConfiguration configuration) {
        this.configuration = configuration;
    }

    public void writeFlakyTestListToFile(List<String> flakyTestList) {
        File flakyTestFile = new File(this.configuration.flakyTestFileLocation());
        try {
            if (CollectionUtils.isNotEmpty(flakyTestList)) {
                String runnerId = this.configuration.runnerId();
                if (StringUtils.isNotEmpty((CharSequence)runnerId)) {
                    flakyTestList = flakyTestList.stream().map(flakyTest -> String.format("%s (%s)", flakyTest, runnerId)).collect(Collectors.toList());
                } else {
                    log.info("Runner ID is empty, not adding it to " + flakyTestFile.getName());
                }
                FileUtils.writeLines((File)flakyTestFile, flakyTestList);
            }
        }
        catch (IOException e) {
            log.error("Unable to write flaky tests to " + flakyTestFile.getName(), (Throwable)e);
        }
    }
}

