/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.test.reporting;

import com.atlassian.jira.rest.client.api.AuthenticationHandler;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.domain.BasicIssue;
import com.atlassian.jira.rest.client.api.domain.Comment;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.SearchResult;
import com.atlassian.jira.rest.client.api.domain.input.IssueInput;
import com.atlassian.jira.rest.client.api.domain.input.IssueInputBuilder;
import com.atlassian.jira.rest.client.api.domain.input.TransitionInput;
import com.atlassian.jira.rest.client.auth.BasicHttpAuthenticationHandler;
import com.atlassian.jira.rest.client.internal.async.AsynchronousJiraRestClientFactory;
import com.atlassian.test.reporting.FlakyTestIssueCreatorProperties;
import com.atlassian.test.reporting.issue.IssueFieldContributors;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Option;
import io.atlassian.util.concurrent.Promise;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class FlakyTestIssueCreator
implements AutoCloseable {
    private static final String JIRA_USERNAME_PROPERTY = "junitflakylistener.jiraUserName";
    private static final String JIRA_PASSWORD_PROPERTY = "junitflakylistener.jiraPassword";
    @VisibleForTesting
    static final String LABEL_PAUSE_COMMENTING = "pause-flaky-comment";
    private final FlakyTestIssueCreatorProperties properties;
    private final JiraRestClient jiraRestClient;
    public final IssueFieldContributors issueFieldContributors;

    public FlakyTestIssueCreator(FlakyTestIssueCreatorProperties properties) {
        this(properties, FlakyTestIssueCreator.createJiraRestClient(properties));
    }

    @VisibleForTesting
    FlakyTestIssueCreator(FlakyTestIssueCreatorProperties properties, JiraRestClient jiraRestClient) {
        this.properties = properties;
        this.issueFieldContributors = new IssueFieldContributors(properties);
        this.jiraRestClient = jiraRestClient;
    }

    private static JiraRestClient createJiraRestClient(FlakyTestIssueCreatorProperties properties) {
        try {
            URI jiraServerUri = new URI(properties.getJiraServerUrl());
            AsynchronousJiraRestClientFactory asynchronousJiraRestClientFactory = new AsynchronousJiraRestClientFactory();
            return asynchronousJiraRestClientFactory.create(jiraServerUri, (AuthenticationHandler)FlakyTestIssueCreator.withAuthenticationHandler());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Cannot create flaky test tracker due to wrong URI format:" + properties.getJiraServerUrl(), e);
        }
    }

    public BasicIssue createJiraIssueForFlakyTest(String testName, String description) {
        IssueInputBuilder issueInputBuilder = new IssueInputBuilder(this.properties.getProjectKey(), Long.valueOf(this.properties.getIssueTypeId()), testName).setComponentsNames((Iterable)Option.option((Object)this.properties.getComponentName(testName)));
        List<String> initialIssueFields = this.properties.initialIssueFields();
        initialIssueFields.forEach(name -> this.issueFieldContributors.getContributor((String)name).contribute(issueInputBuilder, description));
        Promise basicIssuePromise = this.jiraRestClient.getIssueClient().createIssue(issueInputBuilder.build());
        BasicIssue issue = (BasicIssue)basicIssuePromise.claim();
        List<String> secondaryIssueFields = this.properties.getSecondaryIssueFields();
        if (!secondaryIssueFields.isEmpty()) {
            IssueInputBuilder updateInputBuilder = new IssueInputBuilder();
            secondaryIssueFields.forEach(name -> this.issueFieldContributors.getContributor((String)name).contribute(updateInputBuilder, description));
            Promise updateIssuePromise = this.jiraRestClient.getIssueClient().updateIssue(issue.getKey(), updateInputBuilder.build());
            updateIssuePromise.claim();
        }
        return issue;
    }

    public void updateExistingIssue(Issue issue, String comment) {
        if (StringUtils.isNotBlank((CharSequence)this.properties.getFlakyCountFieldId())) {
            double flakyCount = (Double)issue.getField(this.properties.getFlakyCountFieldId()).getValue() + 1.0;
            IssueInput customFieldInput = new IssueInputBuilder().setFieldValue(this.properties.getFlakyCountFieldId(), (Object)flakyCount).build();
            this.jiraRestClient.getIssueClient().updateIssue(issue.getKey(), customFieldInput).claim();
        }
        if (!issue.getLabels().contains(LABEL_PAUSE_COMMENTING)) {
            this.jiraRestClient.getIssueClient().addComment(issue.getCommentsUri(), Comment.valueOf((String)comment)).claim();
        }
    }

    public void reopenIssueIfClosed(Issue issue) {
        this.properties.getReopenTransitions().stream().filter(t -> t.getStatusName().equalsIgnoreCase(issue.getStatus().getName())).findFirst().ifPresent(t -> this.jiraRestClient.getIssueClient().transition(issue, new TransitionInput(t.getReopenTransitionId())).claim());
    }

    public Option<Issue> findFirstFlakyTestIssue(String flakyTestName) {
        Promise searchResultPromise = this.jiraRestClient.getSearchClient().searchJql(String.format("project = '%s' AND issuetype = %s AND summary ~ '\"%s\"'", this.properties.getProjectKey(), this.properties.getIssueTypeId(), flakyTestName));
        try {
            return Iterables.findFirst((Iterable)((SearchResult)searchResultPromise.get()).getIssues(), issue -> issue.getSummary().equalsIgnoreCase(flakyTestName));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to search for flaky test issue: " + e.getMessage(), e);
        }
    }

    @Override
    public void close() throws Exception {
        this.jiraRestClient.close();
    }

    public static boolean isConfigured() {
        return StringUtils.isNotEmpty((CharSequence)System.getProperty(JIRA_USERNAME_PROPERTY)) && StringUtils.isNotEmpty((CharSequence)System.getProperty(JIRA_PASSWORD_PROPERTY));
    }

    @VisibleForTesting
    FlakyTestIssueCreatorProperties getProperties() {
        return this.properties;
    }

    private static BasicHttpAuthenticationHandler withAuthenticationHandler() {
        return new BasicHttpAuthenticationHandler(System.getProperty(JIRA_USERNAME_PROPERTY), System.getProperty(JIRA_PASSWORD_PROPERTY));
    }
}

