/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.test.reporting;

import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Option;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class FlakyTestIssueCreatorProperties {
    private static List<String> ALL_FIELDS = ImmutableList.of((Object)"flakyIssuePriorityId", (Object)"flakyCountFieldId", (Object)"flakyTestLabels", (Object)"issueCustomField1", (Object)"issueSecurityLevelId", (Object)"issueAffectedVersion", (Object)"description");
    private String jiraServerUrl;
    private String projectKey;
    private String componentName;
    private long issueTypeId;
    private String endStatusName;
    private int backToStartStatusTransitionId;
    private long flakyIssuePriorityId;
    private String flakyCountFieldId;
    private String bambooServerUrl;
    private List<String> flakyTestLabels;
    private String issueAffectedVersion;
    private List<String> issueCustomField1;
    private String issueSecurityLevelId;
    private List<String> secondaryIssueFields;
    private List<ReopenTransition> reopenTransitions;
    private List<MatchedComponent> matchedComponents;

    public String getJiraServerUrl() {
        return this.jiraServerUrl;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public String getComponentName(String testName) {
        List<MatchedComponent> components = this.getMatchedComponents();
        for (int i = 0; i < components.size(); ++i) {
            String[] patterns = components.get(i).getPattern();
            if (!Arrays.stream(patterns).anyMatch(testName::matches)) continue;
            return components.get(i).getComponent();
        }
        return this.getDefaultComponentName();
    }

    public String getDefaultComponentName() {
        return this.componentName;
    }

    public List<MatchedComponent> getMatchedComponents() {
        if (this.matchedComponents != null) {
            return this.matchedComponents;
        }
        return Collections.emptyList();
    }

    public long getIssueTypeId() {
        return this.issueTypeId;
    }

    public String getEndStatusName() {
        return this.endStatusName;
    }

    public int getBackToStartStatusTransitionId() {
        return this.backToStartStatusTransitionId;
    }

    public long getFlakyIssuePriorityId() {
        return this.flakyIssuePriorityId;
    }

    public String getFlakyCountFieldId() {
        return this.flakyCountFieldId;
    }

    public String getBambooServerUrl() {
        return this.bambooServerUrl;
    }

    public List<String> getIssueCustomField1() {
        return this.issueCustomField1;
    }

    public String getIssueSecurityLevelId() {
        return this.issueSecurityLevelId;
    }

    public String getIssueAffectedVersion() {
        return this.issueAffectedVersion;
    }

    public List<String> getFlakyTestLabels() {
        return this.flakyTestLabels;
    }

    public List<ReopenTransition> getReopenTransitions() {
        if (this.reopenTransitions == null) {
            this.reopenTransitions = ImmutableList.of((Object)new ReopenTransition(this.getEndStatusName(), this.getBackToStartStatusTransitionId()));
        }
        return this.reopenTransitions;
    }

    public List<String> initialIssueFields() {
        return ImmutableList.copyOf((Collection)CollectionUtils.removeAll(ALL_FIELDS, this.getSecondaryIssueFields()));
    }

    public List<String> getSecondaryIssueFields() {
        return (List)Option.option(this.secondaryIssueFields).getOrElse(Collections.emptyList());
    }

    public String toString() {
        return "FlakyTestIssueCreatorProperties{jiraServerUrl='" + this.jiraServerUrl + '\'' + ", projectKey='" + this.projectKey + '\'' + ", componentName = '" + this.componentName + '\'' + ", issueTypeId=" + this.issueTypeId + ", endStatusName='" + this.endStatusName + '\'' + ", backToStartStatusTransitionId=" + this.backToStartStatusTransitionId + ", flakyIssuePriorityId=" + this.flakyIssuePriorityId + ", flakyCountFieldId='" + this.flakyCountFieldId + '\'' + ", bambooServerUrl='" + this.bambooServerUrl + '\'' + ", flakyTestLabels=" + this.flakyTestLabels + ", issueAffectedVersion=" + this.issueAffectedVersion + ", issueSecurityLevelId=" + this.issueSecurityLevelId + ", issueCustomField1=" + this.issueCustomField1 + ", secondaryIssueFields=" + this.secondaryIssueFields + '}';
    }

    public static class MatchedComponent {
        private String[] patterns;
        private String component;

        public MatchedComponent(String[] patterns, String component) {
            this.patterns = patterns;
            this.component = component;
        }

        public String[] getPattern() {
            return this.patterns;
        }

        public String getComponent() {
            return this.component;
        }
    }

    public static class ReopenTransition {
        private String statusName;
        private int reopenTransitionId;

        public ReopenTransition(String statusName, int reopenTransitionId) {
            this.statusName = statusName;
            this.reopenTransitionId = reopenTransitionId;
        }

        public String getStatusName() {
            return this.statusName;
        }

        public int getReopenTransitionId() {
            return this.reopenTransitionId;
        }
    }
}

