/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.test.reporting;

import com.atlassian.test.reporting.FlakyTestIssueCreatorProperties;
import com.google.gson.Gson;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

class FlakyTestIssueCreatorPropertiesLoader {
    private static final String JIRA_PROJECT_CONFIG_PATH_PROPERTY = "junitflakylistener.jiraProjectConfigPath";
    private static final String DEFAULT_JIRA_PROJECT_CONFIG_LOCATION = "issuecreator_config.json";
    private static final Pattern LABEL_SYSTEM_PROPERTY_PATTERN = Pattern.compile("^\"?~(.*)~\"?$");

    FlakyTestIssueCreatorPropertiesLoader() {
    }

    public static FlakyTestIssueCreatorProperties loadProperties() {
        return FlakyTestIssueCreatorPropertiesLoader.loadProperties(FlakyTestIssueCreatorPropertiesLoader.jiraProjectConfigPath());
    }

    public static FlakyTestIssueCreatorProperties loadProperties(String jiraProjectConfigPath) {
        InputStream propStream = FlakyTestIssueCreatorPropertiesLoader.class.getClassLoader().getResourceAsStream(jiraProjectConfigPath);
        Gson gson = new Gson();
        try {
            FlakyTestIssueCreatorProperties properties = (FlakyTestIssueCreatorProperties)gson.fromJson(IOUtils.toString((InputStream)propStream), FlakyTestIssueCreatorProperties.class);
            if (null != properties.getFlakyTestLabels()) {
                properties.getFlakyTestLabels().replaceAll(label -> {
                    Matcher labelMatcher = LABEL_SYSTEM_PROPERTY_PATTERN.matcher((CharSequence)label);
                    if (labelMatcher.find()) {
                        return System.getProperty(labelMatcher.group(1));
                    }
                    return label;
                });
            }
            FlakyTestIssueCreatorProperties flakyTestIssueCreatorProperties = properties;
            return flakyTestIssueCreatorProperties;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot parse Issue Creator properties, tried to look for '" + jiraProjectConfigPath + "' on the classpath.", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)propStream);
        }
    }

    private static String jiraProjectConfigPath() {
        return System.getProperty(JIRA_PROJECT_CONFIG_PATH_PROPERTY, DEFAULT_JIRA_PROJECT_CONFIG_LOCATION);
    }
}

