/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.test.reporting;

import com.atlassian.Properties;
import com.atlassian.test.reporting.Failure;
import com.atlassian.test.reporting.FileReporter;
import com.atlassian.test.reporting.JUnitFlakyTestConfiguration;
import com.atlassian.test.reporting.JiraReporter;
import com.atlassian.test.reporting.NewFlakyTestException;
import com.atlassian.test.reporting.SourceTranformListener;
import com.atlassian.test.reporting.StatsDReporter;
import com.atlassian.test.reporting.TestOrderLogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import io.atlassian.fugue.Maybe;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Suppliers;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FlakyTestListener {
    private static final Logger log = LoggerFactory.getLogger(FlakyTestListener.class);
    private final Multimap<String, Option<Failure>> flakyTests = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    private final AtomicInteger failuresCounter = new AtomicInteger(0);
    private final Supplier<JUnitFlakyTestConfiguration> configuration;
    private final Supplier<FileReporter> fileReporter;
    private final Supplier<JiraReporter> jiraReporter;
    private final Supplier<StatsDReporter> statsdReporter;
    private final SourceTranformListener sourceTransform;
    private Option<Failure> currentTestFailure = Option.none();
    private Stopwatch stopwatch;

    public FlakyTestListener() {
        this.configuration = Suppliers.memoize(JUnitFlakyTestConfiguration::fromSystemProperties);
        this.fileReporter = Suppliers.memoize(() -> new FileReporter(this.configuration.get()));
        this.jiraReporter = Suppliers.memoize(() -> new JiraReporter(this.configuration.get()));
        this.statsdReporter = Suppliers.memoize(() -> new StatsDReporter(this.configuration.get()));
        this.sourceTransform = SourceTranformListener.tryInstansiate();
    }

    @VisibleForTesting
    FlakyTestListener(JUnitFlakyTestConfiguration configuration, FileReporter fileReporter, JiraReporter jiraReporter, StatsDReporter statsdReporter, SourceTranformListener sourceTranformListener) {
        this.configuration = Suppliers.memoize(() -> configuration);
        this.fileReporter = Suppliers.memoize(() -> fileReporter);
        this.jiraReporter = Suppliers.memoize(() -> jiraReporter);
        this.statsdReporter = Suppliers.memoize(() -> statsdReporter);
        this.sourceTransform = sourceTranformListener;
    }

    public void beforeAllTests() {
        log.info("Using configuration: {}", (Object)this.configuration.get());
        try {
            this.statsdReporter.get().handleBuild();
        }
        catch (Exception e) {
            log.info("Error while sending Datadog stats: {}", (Object)e.getMessage());
            log.debug("Statsd error", (Throwable)e);
        }
    }

    public void beforeTestStart(String className, String methodName) {
        this.stopwatch = new Stopwatch();
        this.currentTestFailure = Option.none();
        if (this.configuration.get().isVerboseLoggingEnabled()) {
            TestOrderLogger.printTestStartUp(className, methodName);
        }
        try {
            this.statsdReporter.get().handleTest();
        }
        catch (Exception e) {
            log.info("Error while sending Datadog stats: {}", (Object)e.getMessage());
            log.debug("Statsd error", (Throwable)e);
        }
    }

    public void afterTestFinish(String className, String methodName) {
        String testName = className + "#" + methodName;
        this.flakyTests.put((Object)testName, this.currentTestFailure);
        this.incrementFailuresCounterIfNeeded();
        if (this.shouldReport(testName)) {
            log.debug("Test {} is flaky, going to report it to JIRA and StatsD", (Object)testName);
            try {
                this.statsdReporter.get().handleFlakyTest(testName);
                Optional<String> jiraKey = this.invokeJiraReporter(testName);
                this.sourceTransform.testFlaked(testName, jiraKey.orElse(""));
            }
            catch (NewFlakyTestException flakyException) {
                try {
                    this.statsdReporter.get().handleBrokenBuild();
                }
                catch (Exception e) {
                    log.info("Error while sending Datadog stats: {}", (Object)e.getMessage());
                    log.debug("Statsd error", (Throwable)e);
                }
                throw flakyException;
            }
            catch (Exception e) {
                log.warn("Error in flaky test listener: {}", (Object)e.getMessage());
                log.debug("Error", (Throwable)e);
            }
        }
        if (this.configuration.get().isVerboseLoggingEnabled()) {
            String status = (String)this.currentTestFailure.fold(() -> "PASSED", f -> "FAILED");
            double testExecutionTime = (double)this.stopwatch.elapsed() / 1000.0;
            this.currentTestFailure.foreach(failure -> {
                System.out.println(failure.toString());
                System.out.println(failure.getTrace());
            });
            TestOrderLogger.printTestEnd(className, methodName, status, testExecutionTime);
        }
    }

    public void reportFailure(Failure failure) {
        this.currentTestFailure = Option.some((Object)failure);
    }

    public void afterAllTests() {
        block2: {
            List<String> flakyTestList = this.flakyTests.keySet().stream().filter(this::isFlakyTest).collect(Collectors.toList());
            this.fileReporter.get().writeFlakyTestListToFile(flakyTestList);
            try {
                this.sourceTransform.testRunFinished();
            }
            catch (Exception e) {
                log.error("Exception while trying to manage a flaky test", (Throwable)e);
                if (!Properties.explodeOnError()) break block2;
                throw new RuntimeException(e);
            }
        }
    }

    private boolean isFlakyTest(String testName) {
        Collection failures = this.flakyTests.get((Object)testName);
        return failures.stream().anyMatch(Option::isEmpty) && failures.stream().anyMatch(Maybe::isDefined);
    }

    private void incrementFailuresCounterIfNeeded() {
        if (this.currentTestFailure.isDefined()) {
            this.failuresCounter.incrementAndGet();
        }
    }

    private boolean shouldReport(String testName) {
        if (this.reportAllFailuresEnabled()) {
            return this.currentTestFailure.isDefined();
        }
        return this.isFlakyTest(testName);
    }

    private Optional<String> invokeJiraReporter(String testName) {
        return this.shouldSkipJiraReporting() ? Optional.empty() : this.jiraReporter.get().handleFlakyTest(testName, this.prepareFailures(testName));
    }

    private boolean shouldSkipJiraReporting() {
        if (!this.configuration.get().shouldLimitFailuresReportedToJiraPerSession()) {
            return false;
        }
        int failuresSize = this.failuresCounter.get();
        if (failuresSize > this.configuration.get().getMaxFailuresReportedToJiraPerSession()) {
            log.warn("Skipping reporting to Jira, as the number of failures {} exceeds the limit of {}", (Object)failuresSize, (Object)this.configuration.get().getMaxFailuresReportedToJiraPerSession());
            return true;
        }
        return false;
    }

    private Collection<Option<Failure>> prepareFailures(String testName) {
        return this.reportAllFailuresEnabled() ? Collections.singleton(this.currentTestFailure) : this.flakyTests.get((Object)testName);
    }

    private boolean reportAllFailuresEnabled() {
        return this.configuration.get().shouldReportAllFailures();
    }

    private class Stopwatch {
        long start = System.currentTimeMillis();

        Stopwatch() {
        }

        long elapsed() {
            long now = System.currentTimeMillis();
            return now - this.start;
        }
    }
}

