/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.test.reporting;

import com.atlassian.test.reporting.Failure;
import com.atlassian.test.reporting.FlakyTestListener;
import java.util.Optional;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

public class JUnit5FlakyTestListener
implements TestExecutionListener {
    private final FlakyTestListener flakyTestListener = new FlakyTestListener();

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.flakyTestListener.beforeAllTests();
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.flakyTestListener.afterAllTests();
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        MethodSource methodSource = this.extractMethodSource(testIdentifier);
        if (methodSource != null) {
            this.flakyTestListener.beforeTestStart(methodSource.getClassName(), methodSource.getMethodName());
        }
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        MethodSource methodSource;
        if (testExecutionResult.getStatus() != TestExecutionResult.Status.SUCCESSFUL) {
            methodSource = this.extractMethodSource(testIdentifier);
            String description = methodSource != null ? methodSource.getClassName() + "#" + methodSource.getMethodName() : "No Tests";
            testExecutionResult.getThrowable().ifPresent(reason -> this.flakyTestListener.reportFailure(new Failure(description, (Throwable)reason)));
        }
        if ((methodSource = this.extractMethodSource(testIdentifier)) != null) {
            this.flakyTestListener.afterTestFinish(methodSource.getClassName(), methodSource.getMethodName());
        }
    }

    private MethodSource extractMethodSource(TestIdentifier testIdentifier) {
        if (testIdentifier.isContainer()) {
            return null;
        }
        Optional testSource = testIdentifier.getSource();
        return testSource.orElse(null);
    }
}

