/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.test.reporting;

import com.google.common.base.MoreObjects;

public final class JUnitFlakyTestConfiguration {
    private static final String RUNNER_ID_PROPERTY = "junitflakylistener.runnerId";
    private static final String BRANCH_NAME_PROPERTY = "junitflakylistener.branchName";
    private static final String CREATE_FLAKY_TEST_TICKET_PROPERTY = "junitflakylistener.trackFlakyTest";
    private static final String UPDATE_FLAKY_TEST_TICKET_ON_BRANCH_PROPERTY = "junitflakylistener.updateIssueOnBranches";
    private static final String FAIL_BRANCH_WITH_NEW_FLAKES_PROPERTY = "junitflakylistener.failBranchWithNewFlakes";
    private static final String RESTRICT_REPORTING_TO_BRANCHES_PROPERTY = "junitflakylistener.trackFlakyTestOnBranchesRegExp";
    private static final String FLAKY_TEST_FILE_PATH_PROPERTY = "junitflakylistener.flakyTestFilePath";
    private static final String STATSD_PREFIX_PROPERTY = "junitflakylistener.statsdPrefix";
    private static final String STATSD_HOST_PROPERTY = "junitflakylistener.statsdHost";
    private static final String STATSD_PORT_PROPERTY = "junitflakylistener.statsdPort";
    private static final String REPORT_BRANCH_NAME_PROPERTY = "junitflakylistener.reportBranchName";
    private static final String REPORT_ALL_FAILURES_PROPERTY = "junitflakylistener.reportAllFailures";
    private static final String MAX_FAILURES_REPORTED_TO_JIRA_PER_SESSION_PROPERTY = "junitflakylistener.maxFailuresReportedToJiraPerSession";
    private static final String VERBOSE_TEST_LOGGING_PROPERTY = "junitflakylistener.deprecatedVerboseTestLogging";
    private static final String DEFAULT_FLAKY_TESTS_FILE_PATH = "target/flakyTests.txt";
    private static final String ALLOW_ANY_BRANCH = ".*";
    private static final String DEFAULT_STATSD_HOST = "statsd.domain.dev.atl-inf.io";
    private static final int DEFAULT_STATSD_PORT = 8125;
    private static final int DEFAULT_MAX_FAILURES_REPORTED_TO_JIRA_PER_SESSION = 0;
    private final String runnerId;
    private final String branchName;
    private final boolean issueCreationEnabled;
    private final boolean updateIssueOnBranches;
    private final boolean failBranchWithNewFlakes;
    private final String branchNameRegExp;
    private final String flakyTestFileLocation;
    private final String statsdPrefix;
    private final String statsdHost;
    private final int statsdPort;
    private final boolean reportBranchName;
    private final boolean reportAllFailures;
    private final boolean limitFailuresReportedToJiraPerSessionEnabled;
    private final int maxFailuresReportedToJiraPerSession;

    private JUnitFlakyTestConfiguration(String runnerId, String branchName, boolean issueCreationEnabled, boolean updateIssueOnBranches, boolean failBranchWithNewFlakes, String branchNameRegExp, String flakyTestFileLocation, String statsdPrefix, String statsdHost, int statsdPort, boolean reportBranchName, boolean reportAllFailures, boolean limitFailuresReportedToJiraPerSessionEnabled, int maxFailuresReportedToJiraPerSession) {
        this.runnerId = runnerId;
        this.branchName = branchName;
        this.issueCreationEnabled = issueCreationEnabled;
        this.updateIssueOnBranches = updateIssueOnBranches;
        this.failBranchWithNewFlakes = failBranchWithNewFlakes;
        this.branchNameRegExp = branchNameRegExp;
        this.flakyTestFileLocation = flakyTestFileLocation;
        this.statsdPrefix = statsdPrefix;
        this.statsdHost = statsdHost;
        this.statsdPort = statsdPort;
        this.reportBranchName = reportBranchName;
        this.reportAllFailures = reportAllFailures;
        this.limitFailuresReportedToJiraPerSessionEnabled = limitFailuresReportedToJiraPerSessionEnabled;
        this.maxFailuresReportedToJiraPerSession = maxFailuresReportedToJiraPerSession;
    }

    public static JUnitFlakyTestConfiguration fromSystemProperties() {
        return new JUnitFlakyTestConfigurationBuilder().withRunnerId(System.getProperty(RUNNER_ID_PROPERTY, "")).withBranchName(System.getProperty(BRANCH_NAME_PROPERTY, "")).withCreateIssue(Boolean.getBoolean(CREATE_FLAKY_TEST_TICKET_PROPERTY)).withUpdateIssueOnBranches("true".equals(System.getProperty(UPDATE_FLAKY_TEST_TICKET_ON_BRANCH_PROPERTY, "true"))).withFailBranchWithNewFlakes("true".equals(System.getProperty(FAIL_BRANCH_WITH_NEW_FLAKES_PROPERTY, "true"))).withFailBuildOnBranches(System.getProperty(RESTRICT_REPORTING_TO_BRANCHES_PROPERTY, ALLOW_ANY_BRANCH)).withFlakyTestFileLocation(System.getProperty(FLAKY_TEST_FILE_PATH_PROPERTY, DEFAULT_FLAKY_TESTS_FILE_PATH)).withStatsdPrefix(System.getProperty(STATSD_PREFIX_PROPERTY, "")).withStatsdHost(System.getProperty(STATSD_HOST_PROPERTY, DEFAULT_STATSD_HOST)).withStatsdPort(System.getProperty(STATSD_PORT_PROPERTY, Integer.toString(8125))).withReportBranchName("true".equals(System.getProperty(REPORT_BRANCH_NAME_PROPERTY, "false"))).withReportAllFailures("true".equals(System.getProperty(REPORT_ALL_FAILURES_PROPERTY, "false"))).withLimitFailuresReportedToJiraPerSessionEnabled(JUnitFlakyTestConfiguration.isValidMaxFailuresReportedToJiraPerSessionProvided()).withMaxFailureReportedToJiraPerSession(JUnitFlakyTestConfiguration.getMaxFailuresReportedToJiraPerSessionFromSystemProperty()).create();
    }

    public static JUnitFlakyTestConfigurationBuilder builder() {
        return new JUnitFlakyTestConfigurationBuilder();
    }

    public String runnerId() {
        return this.runnerId;
    }

    public boolean shouldCreateJiraTicket() {
        return this.issueCreationEnabled && this.currentBranchNameMatchesRestriction();
    }

    public boolean shouldUpdateIssueOnBranches() {
        return this.updateIssueOnBranches;
    }

    public boolean shouldFailBranchWithNewFlakes() {
        return this.failBranchWithNewFlakes;
    }

    public boolean isBranchBuild() {
        return !this.currentBranchNameMatchesRestriction();
    }

    private boolean currentBranchNameMatchesRestriction() {
        return this.branchName.matches(this.branchNameRegExp);
    }

    public String flakyTestFileLocation() {
        return this.flakyTestFileLocation;
    }

    public String statsdPrefix() {
        return this.statsdPrefix;
    }

    public String statsdHost() {
        return this.statsdHost;
    }

    public int statsdPort() {
        return this.statsdPort;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public boolean shouldReportBranchName() {
        return this.reportBranchName;
    }

    public boolean shouldReportAllFailures() {
        return this.reportAllFailures;
    }

    public boolean shouldLimitFailuresReportedToJiraPerSession() {
        return this.limitFailuresReportedToJiraPerSessionEnabled;
    }

    public int getMaxFailuresReportedToJiraPerSession() {
        return this.maxFailuresReportedToJiraPerSession;
    }

    @Deprecated
    public boolean isVerboseLoggingEnabled() {
        return Boolean.getBoolean(VERBOSE_TEST_LOGGING_PROPERTY);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("runnerId", (Object)this.runnerId).add("branchName", (Object)this.branchName).add("issueCreationEnabled", this.issueCreationEnabled).add("updateIssueOnBranches", this.updateIssueOnBranches).add("failBranchWithNewFlakes", this.failBranchWithNewFlakes).add("branchNameRegExp", (Object)this.branchNameRegExp).add("flakyTestFileLocation", (Object)this.flakyTestFileLocation).add("statsdPrefix", (Object)this.statsdPrefix).add("statsdHost", (Object)this.statsdHost).add("statsdPort", this.statsdPort).add("reportBranchName", this.reportBranchName).add("reportAllFailures", this.reportAllFailures).add("limitFailuresReportedToJiraPerSessionEnabled", this.limitFailuresReportedToJiraPerSessionEnabled).add("maxFailuresReportedToJiraPerSession", this.maxFailuresReportedToJiraPerSession).toString();
    }

    private static boolean isValidMaxFailuresReportedToJiraPerSessionProvided() {
        String maxFailuresReportedToJiraPerSession = System.getProperty(MAX_FAILURES_REPORTED_TO_JIRA_PER_SESSION_PROPERTY, "");
        if ("".equals(maxFailuresReportedToJiraPerSession)) {
            return false;
        }
        try {
            int maxFailures = Integer.parseInt(maxFailuresReportedToJiraPerSession);
            return maxFailures > 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static int getMaxFailuresReportedToJiraPerSessionFromSystemProperty() {
        String maxFailuresReportedToJiraPerSession = System.getProperty(MAX_FAILURES_REPORTED_TO_JIRA_PER_SESSION_PROPERTY, "");
        if ("".equals(maxFailuresReportedToJiraPerSession)) {
            return 0;
        }
        try {
            int maxFailures = Integer.parseInt(maxFailuresReportedToJiraPerSession);
            return Math.max(maxFailures, 0);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static class JUnitFlakyTestConfigurationBuilder {
        private String runnerId = "";
        private boolean issueCreationEnabled = false;
        private boolean updateIssueOnBranches = true;
        private boolean failBranchWithNewFlakes = true;
        private String flakyTestFileLocation = "target/flakyTests.txt";
        private String branchName = "";
        private String branchNameRegExp = ".*";
        private String statsdPrefix = "";
        private String statsdHost = "statsd.domain.dev.atl-inf.io";
        private int statsdPort = 8125;
        private boolean reportBranchName = false;
        private boolean reportAllFailures = false;
        private boolean limitFailuresReportedToJiraPerSessionEnabled = false;
        private int maxFailureReportedToJiraPerSession = 0;

        public JUnitFlakyTestConfigurationBuilder withRunnerId(String runnerId) {
            this.runnerId = runnerId;
            return this;
        }

        public JUnitFlakyTestConfigurationBuilder withIssueCreationEnabled() {
            return this.withCreateIssue(true);
        }

        public JUnitFlakyTestConfigurationBuilder withIssueCreationDisabled() {
            return this.withCreateIssue(false);
        }

        public JUnitFlakyTestConfigurationBuilder withCreateIssue(boolean issueCreationEnabled) {
            this.issueCreationEnabled = issueCreationEnabled;
            return this;
        }

        public JUnitFlakyTestConfigurationBuilder withBranchName(String branchName) {
            this.branchName = branchName;
            return this;
        }

        public JUnitFlakyTestConfigurationBuilder withFailBuildOnBranches(String branchNameRegExp) {
            this.branchNameRegExp = branchNameRegExp;
            return this;
        }

        public JUnitFlakyTestConfigurationBuilder withFailBranchWithNewFlakes(boolean failBranchWithNewFlakes) {
            this.failBranchWithNewFlakes = failBranchWithNewFlakes;
            return this;
        }

        public JUnitFlakyTestConfigurationBuilder withFlakyTestFileLocation(String flakyTestFileLocation) {
            this.flakyTestFileLocation = flakyTestFileLocation;
            return this;
        }

        public JUnitFlakyTestConfigurationBuilder withUpdateIssueOnBranches(boolean createIssueOnBranches) {
            this.updateIssueOnBranches = createIssueOnBranches;
            return this;
        }

        public JUnitFlakyTestConfigurationBuilder withStatsdPrefix(String statsdPrefix) {
            this.statsdPrefix = statsdPrefix;
            return this;
        }

        public JUnitFlakyTestConfigurationBuilder withStatsdHost(String statsdHost) {
            this.statsdHost = statsdHost;
            return this;
        }

        public JUnitFlakyTestConfigurationBuilder withStatsdPort(String statsdPort) {
            this.statsdPort = Integer.parseInt(statsdPort);
            return this;
        }

        public JUnitFlakyTestConfigurationBuilder withReportBranchName(boolean reportBranchName) {
            this.reportBranchName = reportBranchName;
            return this;
        }

        public JUnitFlakyTestConfigurationBuilder withReportAllFailures(boolean reportAllFailures) {
            this.reportAllFailures = reportAllFailures;
            return this;
        }

        public JUnitFlakyTestConfigurationBuilder withLimitFailuresReportedToJiraPerSessionEnabled(boolean limitFailuresReportedToJiraPerSessionEnabled) {
            this.limitFailuresReportedToJiraPerSessionEnabled = limitFailuresReportedToJiraPerSessionEnabled;
            return this;
        }

        public JUnitFlakyTestConfigurationBuilder withMaxFailureReportedToJiraPerSession(int maxFailureReportedToJiraPerSession) {
            this.maxFailureReportedToJiraPerSession = maxFailureReportedToJiraPerSession;
            return this;
        }

        public JUnitFlakyTestConfiguration create() {
            return new JUnitFlakyTestConfiguration(this.runnerId, this.branchName, this.issueCreationEnabled, this.updateIssueOnBranches, this.failBranchWithNewFlakes, this.branchNameRegExp, this.flakyTestFileLocation, this.statsdPrefix, this.statsdHost, this.statsdPort, this.reportBranchName, this.reportAllFailures, this.limitFailuresReportedToJiraPerSessionEnabled, this.maxFailureReportedToJiraPerSession);
        }
    }
}

