/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.test.reporting;

import com.atlassian.test.reporting.Failure;
import com.atlassian.test.reporting.FlakyTestListener;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;

public final class JUnitFlakyTestListener
extends RunListener {
    private final FlakyTestListener flakyTestListener = new FlakyTestListener();

    public void testRunStarted(Description description) {
        this.flakyTestListener.beforeAllTests();
    }

    public void testStarted(Description description) {
        this.flakyTestListener.beforeTestStart(description.getClassName(), description.getMethodName());
    }

    public void testFinished(Description description) {
        this.flakyTestListener.afterTestFinish(description.getClassName(), description.getMethodName());
    }

    public void testFailure(org.junit.runner.notification.Failure failure) {
        this.flakyTestListener.reportFailure(new Failure(failure.getTestHeader(), failure.getException()));
    }

    public void testRunFinished(Result result) {
        this.flakyTestListener.afterAllTests();
    }
}

