/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.test.reporting;

import com.atlassian.test.reporting.Failure;
import io.atlassian.fugue.Maybe;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

final class JiraMessageRenderer
implements Function<Collection<Option<Failure>>, String> {
    private static final String USE_BITBUCKET_PROPERTY = "junitflakylistener.useBitbucketPipelines";
    private static final String NO_BRANCH = "NONE";
    private final String buildId;
    private final String branchName;
    private final boolean shouldReportBranchName;
    private final String buildServerUrl;
    private final boolean useBitbucketPipelines = Boolean.getBoolean("junitflakylistener.useBitbucketPipelines");

    JiraMessageRenderer(String buildId, String buildServerUrl) {
        this(buildId, buildServerUrl, NO_BRANCH);
    }

    JiraMessageRenderer(String buildId, String buildServerUrl, String branchName) {
        this.buildId = buildId;
        this.buildServerUrl = buildServerUrl;
        this.branchName = branchName == null ? null : branchName.replace('-', '_');
        this.shouldReportBranchName = !NO_BRANCH.equals(this.branchName) && this.branchName != null;
    }

    @Override
    public String apply(Collection<Option<Failure>> testFailures) {
        StringBuilder descriptionBuilder = new StringBuilder();
        descriptionBuilder.append("*Runner Id: ").append(this.buildId).append("*");
        descriptionBuilder.append('\n');
        if (this.shouldReportBranchName) {
            descriptionBuilder.append("*Branch Name: ").append(this.branchName).append("*");
            descriptionBuilder.append('\n');
        }
        if (StringUtils.isNotEmpty((CharSequence)this.buildId)) {
            if (this.useBitbucketPipelines) {
                descriptionBuilder.append(String.format("[Test Artifacts link|%s/addon/pipelines/home#!/results/%s]", this.buildServerUrl, this.buildId));
            } else {
                descriptionBuilder.append(String.format("[Test Artifacts link|%s/browse/%s/artifact]", this.buildServerUrl, this.buildId));
            }
        }
        descriptionBuilder.append("{noformat}");
        descriptionBuilder.append('\n');
        testFailures.stream().filter(Maybe::isDefined).forEach(failure -> {
            descriptionBuilder.append(this.createFailureLog((Failure)failure.get()));
            descriptionBuilder.append('\n');
        });
        descriptionBuilder.append('\n');
        descriptionBuilder.append("{noformat}");
        return descriptionBuilder.toString();
    }

    private String createFailureLog(Failure failure) {
        return JiraMessageRenderer.prepareMessagePrefix(failure) + JiraMessageRenderer.prepareMessageBody(failure);
    }

    private static String prepareMessagePrefix(Failure failure) {
        return failure.causedBuildFailure() ? "BUILD FAILURE\n" : "";
    }

    private static String prepareMessageBody(Failure failure) {
        return "Exception - " + failure.getMessage() + "\n" + ExceptionUtils.getStackTrace((Throwable)failure.getException());
    }
}

