/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.test.reporting;

import com.atlassian.jira.rest.client.api.domain.BasicIssue;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.test.reporting.Failure;
import com.atlassian.test.reporting.FlakyTestIssueCreator;
import com.atlassian.test.reporting.FlakyTestIssueCreatorFactory;
import com.atlassian.test.reporting.FlakyTestIssueCreatorProperties;
import com.atlassian.test.reporting.FlakyTestIssueCreatorPropertiesLoader;
import com.atlassian.test.reporting.JUnitFlakyTestConfiguration;
import com.atlassian.test.reporting.JiraMessageRenderer;
import com.atlassian.test.reporting.NewFlakyTestException;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraReporter {
    private static final String BUILD_SERVER_URL_PROPERTY = "junitflakylistener.buildServerUrl";
    private static final Logger log = LoggerFactory.getLogger(JiraReporter.class);
    private final JUnitFlakyTestConfiguration configuration;
    private final Function<Collection<Option<Failure>>, String> jiraMessageRenderer;

    public JiraReporter(JUnitFlakyTestConfiguration configuration) {
        this(configuration, FlakyTestIssueCreatorPropertiesLoader.loadProperties());
    }

    @VisibleForTesting
    JiraReporter(JUnitFlakyTestConfiguration configuration, FlakyTestIssueCreatorProperties properties) {
        this.configuration = configuration;
        String buildServerUrl = StringUtils.isNotEmpty((CharSequence)System.getProperty(BUILD_SERVER_URL_PROPERTY, "")) ? System.getProperty(BUILD_SERVER_URL_PROPERTY) : properties.getBambooServerUrl();
        this.jiraMessageRenderer = configuration.shouldReportBranchName() ? new JiraMessageRenderer(configuration.runnerId(), buildServerUrl, configuration.getBranchName()) : new JiraMessageRenderer(configuration.runnerId(), buildServerUrl);
    }

    public Optional<String> handleFlakyTest(String fullTestName, String message) {
        Optional optional;
        block21: {
            if (!FlakyTestIssueCreator.isConfigured()) {
                log.info("Found test {} to be flaky but unable to confirm if test is already known due to lack of JIRA credentials.", (Object)fullTestName);
                return Optional.empty();
            }
            if (this.configuration.isBranchBuild()) {
                Optional optional2;
                block20: {
                    if (this.configuration.shouldUpdateIssueOnBranches() || this.configuration.shouldFailBranchWithNewFlakes()) {
                        this.handleFlakyTestOnBranchBuilds(fullTestName, message);
                    }
                    FlakyTestIssueCreator flakyTestIssueCreator = FlakyTestIssueCreatorFactory.createInstance();
                    try {
                        optional2 = flakyTestIssueCreator.findFirstFlakyTestIssue(fullTestName).map(x -> x.getKey()).toOptional();
                        if (flakyTestIssueCreator == null) break block20;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (flakyTestIssueCreator != null) {
                                try {
                                    flakyTestIssueCreator.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            return Optional.empty();
                        }
                    }
                    flakyTestIssueCreator.close();
                }
                return optional2;
            }
            if (this.configuration.shouldCreateJiraTicket()) {
                return this.handleFlakyTestOnMaster(fullTestName, message);
            }
            log.info("Issue creation disabled, not creating tickets for flaky tests");
            FlakyTestIssueCreator flakyTestIssueCreator = FlakyTestIssueCreatorFactory.createInstance();
            try {
                optional = flakyTestIssueCreator.findFirstFlakyTestIssue(fullTestName).map(x -> x.getKey()).toOptional();
                if (flakyTestIssueCreator == null) break block21;
            }
            catch (Throwable throwable) {
                try {
                    if (flakyTestIssueCreator != null) {
                        try {
                            flakyTestIssueCreator.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return Optional.empty();
                }
            }
            flakyTestIssueCreator.close();
        }
        return optional;
    }

    public Optional<String> handleFlakyTest(String fullTestName, Collection<Option<Failure>> failures) {
        return this.handleFlakyTest(fullTestName, this.jiraMessageRenderer.apply(failures));
    }

    private Optional<String> handleFlakyTestOnBranchBuilds(String fullTestName, String message) {
        FlakyTestIssueCreator creator = FlakyTestIssueCreatorFactory.createInstance();
        Option<Issue> existingIssueOrNone = creator.findFirstFlakyTestIssue(fullTestName);
        if (existingIssueOrNone.isEmpty() && this.configuration.shouldFailBranchWithNewFlakes()) {
            log.info("Test {} is not known as flaky, preventing the branch build from going green...", (Object)fullTestName);
            throw new NewFlakyTestException("Test " + fullTestName + " showed a flaky behaviour (failed first and passed in the second run) but is not known to be flaky. If you've just written this test, please carefully review the test itself and make sure it is reliable before adding it to master.");
        }
        if (!existingIssueOrNone.isEmpty() && this.configuration.shouldUpdateIssueOnBranches()) {
            Issue issue = (Issue)existingIssueOrNone.get();
            log.info("Test {} is known to be flaky and tracked as {}; reporting it is still happening", (Object)fullTestName, (Object)issue.getSelf());
            creator.updateExistingIssue(issue, message);
            return Optional.of(issue.getKey());
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<String> handleFlakyTestOnMaster(String fullTestName, String message) {
        try (FlakyTestIssueCreator flakyTestIssueCreator = FlakyTestIssueCreatorFactory.createInstance();){
            Option<Issue> existingIssueOrNone = flakyTestIssueCreator.findFirstFlakyTestIssue(fullTestName);
            if (existingIssueOrNone.isEmpty()) {
                log.info("Test {} is not known as flaky, reporting it...", (Object)fullTestName);
                BasicIssue issue = flakyTestIssueCreator.createJiraIssueForFlakyTest(fullTestName, message);
                log.info("Flaky test {} tracked as {}", (Object)fullTestName, (Object)issue.getSelf());
                Optional<String> optional2 = Optional.of(issue.getKey());
                return optional2;
            }
            Issue issue = (Issue)existingIssueOrNone.get();
            log.info("Test {} is known to be flaky and tracked as {}; reporting it is still happening...", (Object)fullTestName, (Object)issue.getSelf());
            flakyTestIssueCreator.reopenIssueIfClosed(issue);
            flakyTestIssueCreator.updateExistingIssue(issue, message);
            Optional<String> optional = Optional.of(issue.getKey());
            return optional;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Cannot create or update flaky test ticket", (Throwable)e);
                return Optional.empty();
            }
            log.warn("Cannot create or update flaky test ticket (reason: {})", (Object)e.getMessage());
            return Optional.empty();
        }
    }
}

