/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.test.reporting;

import com.atlassian.Properties;
import com.atlassian.stash.BitBucketServer;
import com.atlassian.stash.GitShim;
import com.atlassian.test.reporting.NilSourceTranformListener;
import com.atlassian.test.reporting.SourceTranformListenerImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface SourceTranformListener {
    public static final Logger log = LoggerFactory.getLogger(SourceTranformListener.class);

    public static SourceTranformListener tryInstansiate() {
        if (StringUtils.isEmpty((CharSequence)Properties.repoProject()) || StringUtils.isEmpty((CharSequence)Properties.repoSlug())) {
            return new NilSourceTranformListener();
        }
        try {
            return new SourceTranformListenerImpl(BitBucketServer.withGit(new GitShim(Properties.repoWorkingDir())).withUser(Properties.repoUserName(), Properties.repoUserEmail()).forRepo(Properties.repoProject(), Properties.repoSlug()).build());
        }
        catch (IllegalArgumentException e) {
            log.warn(e.getMessage());
            return new NilSourceTranformListener();
        }
        catch (Exception e) {
            log.error("Bulkhead caught: ", (Throwable)e);
            return new NilSourceTranformListener();
        }
    }

    public void testFlaked(String var1, String var2);

    public void testRunFinished();
}

