/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.test.reporting;

import com.atlassian.Properties;
import com.atlassian.code.transforms.add.annotation.FlakeyTransform;
import com.atlassian.concurrent.GoChanReader;
import com.atlassian.stash.BitBucketServer;
import com.atlassian.test.reporting.SourceTranformListener;
import com.atlassian.test.reporting.repo.tools.TransformTestNamesToSpoonParams;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceTranformListenerImpl
implements SourceTranformListener {
    private static Logger LOG = LoggerFactory.getLogger(SourceTranformListenerImpl.class);
    private final BitBucketServer.Repo stashRepo;
    private final Map<String, String> testNameIssueKeyPairs = new TreeMap<String, String>();

    public SourceTranformListenerImpl(BitBucketServer.Repo stashRepo) {
        this.stashRepo = stashRepo;
    }

    @Override
    public void testFlaked(String testName, String jiraIssueKey) {
        this.testNameIssueKeyPairs.put(testName, jiraIssueKey);
    }

    @Override
    public void testRunFinished() {
        File gitRoot = new File(".").getAbsoluteFile();
        GoChanReader<FlakeyTransform.Params> q = new TransformTestNamesToSpoonParams().apply(gitRoot, this.testNameIssueKeyPairs);
        try {
            FlakeyTransform f = new FlakeyTransform();
            q.forEach(entry -> f.accept(entry));
            try {
                String upstreamBranch = "fixing-master/flaky-" + UUID.randomUUID().toString();
                this.stashRepo.setOriginURL();
                this.stashRepo.pushWorkspace(upstreamBranch);
                this.stashRepo.openPullRequestFrom(upstreamBranch).withReviewers(Properties.reviewerUserName()).withOAuth(Properties.oauthToken()).perform();
            }
            catch (IOException | RuntimeException | URISyntaxException e) {
                LOG.error("While pushing / opening PR", (Throwable)e);
            }
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted, probably a bad thing happened.", (Throwable)e);
        }
    }
}

