/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.test.reporting;

import com.atlassian.test.reporting.JUnitFlakyTestConfiguration;
import com.timgroup.statsd.NonBlockingStatsDClient;
import com.timgroup.statsd.StatsDClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsDReporter {
    private static final Logger log = LoggerFactory.getLogger(StatsDReporter.class);
    private static final String SFX_TAG = "obs_sfx_enable:true";
    private final JUnitFlakyTestConfiguration configuration;
    private final StatsDClient statsd;

    public StatsDReporter(JUnitFlakyTestConfiguration configuration) {
        this(configuration, StatsDReporter.createStatsdClient(configuration));
    }

    public StatsDReporter(JUnitFlakyTestConfiguration configuration, StatsDClient statsd) {
        this.configuration = configuration;
        this.statsd = statsd;
        if (configuration.statsdPrefix().isEmpty()) {
            log.warn("statsd prefix is not set so metrics will not be sent to {}:{}", (Object)configuration.statsdHost(), (Object)configuration.statsdPort());
        }
    }

    public void handleFlakyTest(String fullTestName) {
        this.incrementCounter("tests.flakytest", Collections.singletonList(String.format("test-name:%s", fullTestName)));
    }

    public void handleTest() {
        this.incrementCounter("tests.testrun");
    }

    public void handleBuild() {
        this.incrementCounter("tests.buildrun");
    }

    public void handleBrokenBuild() {
        this.incrementCounter("tests.brokenbuild");
    }

    private void incrementCounter(String aspect) {
        this.incrementCounter(aspect, Collections.emptyList());
    }

    private void incrementCounter(String aspect, List<String> tags) {
        ArrayList<String> tagsListFinal = new ArrayList<String>(tags);
        tagsListFinal.add(SFX_TAG);
        if (!this.configuration.statsdPrefix().isEmpty()) {
            this.statsd.incrementCounter(aspect, tagsListFinal.toArray(new String[0]));
        }
    }

    private static StatsDClient createStatsdClient(JUnitFlakyTestConfiguration configuration) {
        String runnerTag = String.format("runnerid:%s", configuration.runnerId());
        String isBranchBuild = String.format("isbranch:%s", configuration.isBranchBuild());
        NonBlockingStatsDClient statsd = new NonBlockingStatsDClient(configuration.statsdPrefix(), configuration.statsdHost(), configuration.statsdPort(), new String[]{isBranchBuild});
        log.info("Created statsd reporter with client pointing to {}:{}", (Object)configuration.statsdHost(), (Object)configuration.statsdPort());
        return statsd;
    }
}

