/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.test.reporting.issue;

import com.atlassian.jira.rest.client.api.domain.input.ComplexIssueInputFieldValue;
import com.atlassian.jira.rest.client.api.domain.input.IssueInputBuilder;
import com.atlassian.test.reporting.FlakyTestIssueCreatorProperties;
import com.atlassian.test.reporting.issue.AbstractIssueFieldContributor;
import com.atlassian.test.reporting.issue.IssueFieldContributor;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class IssueFieldContributors {
    private Map<String, IssueFieldContributor> contributorMap;

    public IssueFieldContributors(FlakyTestIssueCreatorProperties properties) {
        this.initContributors(properties);
    }

    private void initContributors(FlakyTestIssueCreatorProperties properties) {
        this.contributorMap = new ImmutableMap.Builder().put((Object)"description", (Object)new AbstractIssueFieldContributor(properties){

            @Override
            public void contribute(IssueInputBuilder issueInputBuilder, String description) {
                issueInputBuilder.setDescription(description);
            }
        }).put((Object)"flakyTestLabels", (Object)new AbstractIssueFieldContributor(properties){

            @Override
            public void contribute(IssueInputBuilder issueInputBuilder, String description) {
                issueInputBuilder.setFieldValue("labels", this.properties.getFlakyTestLabels());
            }
        }).put((Object)"flakyCountFieldId", (Object)new AbstractIssueFieldContributor(properties){

            @Override
            public void contribute(IssueInputBuilder issueInputBuilder, String description) {
                if (StringUtils.isNotBlank((CharSequence)this.properties.getFlakyCountFieldId())) {
                    issueInputBuilder.setFieldValue(this.properties.getFlakyCountFieldId(), (Object)1L);
                }
            }
        }).put((Object)"flakyIssuePriorityId", (Object)new AbstractIssueFieldContributor(properties){

            @Override
            public void contribute(IssueInputBuilder issueInputBuilder, String description) {
                issueInputBuilder.setPriorityId(Long.valueOf(this.properties.getFlakyIssuePriorityId()));
            }
        }).put((Object)"issueCustomField1", (Object)new AbstractIssueFieldContributor(properties){

            @Override
            public void contribute(IssueInputBuilder issueInputBuilder, String description) {
                List<String> field1 = this.properties.getIssueCustomField1();
                if (field1 != null && field1.size() == 2) {
                    issueInputBuilder.setFieldValue(field1.get(0), ComplexIssueInputFieldValue.with((String)"id", (Object)field1.get(1)));
                }
            }
        }).put((Object)"issueAffectedVersion", (Object)new AbstractIssueFieldContributor(properties){

            @Override
            public void contribute(IssueInputBuilder issueInputBuilder, String description) {
                if (StringUtils.isNotBlank((CharSequence)this.properties.getIssueAffectedVersion())) {
                    issueInputBuilder.setAffectedVersionsNames((Iterable)Option.option((Object)this.properties.getIssueAffectedVersion()));
                }
            }
        }).put((Object)"issueSecurityLevelId", (Object)new AbstractIssueFieldContributor(properties){

            @Override
            public void contribute(IssueInputBuilder issueInputBuilder, String description) {
                if (StringUtils.isNotBlank((CharSequence)this.properties.getIssueSecurityLevelId())) {
                    issueInputBuilder.setFieldValue("security", ComplexIssueInputFieldValue.with((String)"id", (Object)this.properties.getIssueSecurityLevelId()));
                }
            }
        }).build();
    }

    public IssueFieldContributor getContributor(String name) {
        return (IssueFieldContributor)Preconditions.checkNotNull((Object)this.contributorMap.get(name));
    }
}

