/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.test.reporting.repo.tools;

import com.atlassian.code.transforms.add.annotation.FlakeyTransform;
import com.atlassian.concurrent.GoChan;
import com.atlassian.concurrent.GoChanReader;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class TransformTestNamesToSpoonParams
implements BiFunction<File, Map<String, String>, GoChanReader<FlakeyTransform.Params>> {
    private static final Pattern testNameSplitter = Pattern.compile("^(.*)\\.(.*?)$");
    static final DateFormat YMDFormat = new SimpleDateFormat("yyyy/MM/dd");

    public static Collection<File> getAllSourceDirsUnder(File gitRoot) {
        return FileUtils.listFilesAndDirs((File)gitRoot, (IOFileFilter)FalseFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE).stream().filter(x -> x.getName().equals("src")).collect(Collectors.toList());
    }

    public static Function<String, String> sourcePath(String fullyQualifiedClassName) {
        return root -> root + fullyQualifiedClassName.replace('.', '/') + ".java";
    }

    public static Optional<String> srcDirContainingClass(Collection<File> srcDirs, String className) {
        return srcDirs.stream().map(x -> x.getAbsolutePath() + "/test/java/").filter(x -> new File(TransformTestNamesToSpoonParams.sourcePath(className).apply((String)x)).exists()).findFirst();
    }

    @Override
    public GoChanReader<FlakeyTransform.Params> apply(File gitRoot, Map<String, String> testNameIssueKeyPairs) {
        GoChan<FlakeyTransform.Params> q = new GoChan<FlakeyTransform.Params>();
        Collection<File> srcDirs = TransformTestNamesToSpoonParams.getAllSourceDirsUnder(gitRoot);
        Executors.newFixedThreadPool(1).execute(() -> {
            try {
                Calendar cal = Calendar.getInstance();
                cal.add(2, 3);
                String timestamp = YMDFormat.format(cal.getTime());
                for (Map.Entry entry : testNameIssueKeyPairs.entrySet()) {
                    Matcher m = testNameSplitter.matcher((CharSequence)entry.getKey());
                    if (!m.matches()) {
                        System.out.println("Unable to identify test method: " + (String)entry.getKey());
                        continue;
                    }
                    try {
                        FlakeyTransform.Params params = new FlakeyTransform.Params();
                        params.className = m.group(1);
                        params.methodName = m.group(2);
                        params.jiraIssueKey = (String)entry.getValue();
                        params.timeStamp = timestamp;
                        params.srcRoot = TransformTestNamesToSpoonParams.srcDirContainingClass(srcDirs, params.className).get();
                        q.send(params);
                    }
                    catch (InterruptedException | NoSuchElementException exception) {}
                }
            }
            finally {
                q.close();
            }
        });
        return q;
    }

    private static class NoFilesFilter
    implements IOFileFilter {
        private NoFilesFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() && file.getName().equals("src");
        }

        public boolean accept(File file, String s) {
            return false;
        }
    }
}

