/*
 * Decompiled with CFR 0.152.
 */
package it;

import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.plugins.osgi.test.AtlassianPluginsTestRunner;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.extensions.projects.IssueTypeData;
import com.radiantminds.roadmap.common.extensions.projects.ListProjectResult;
import com.radiantminds.roadmap.common.extensions.projects.ProjectAccess;
import com.radiantminds.roadmap.common.extensions.projects.ProjectData;
import com.radiantminds.roadmap.common.extensions.projects.ProjectExtension;
import com.radiantminds.roadmap.common.extensions.projects.ProjectIssueTypeData;
import it.BaseIntegrationTest;
import it.login.Login;
import it.login.User;
import it.testdata.TestData;
import java.util.Set;
import javax.annotation.Nullable;
import junit.framework.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=AtlassianPluginsTestRunner.class)
public class ProjectExtensionTest
extends BaseIntegrationTest {
    private final ProjectExtension projectExtension;
    private final ProjectService projectService;

    public ProjectExtensionTest(ProjectExtension projectExtension, ProjectService projectService) {
        this.projectExtension = projectExtension;
        this.projectService = projectService;
    }

    @Test
    public void testExcluded() throws Exception {
        this.withProjects(new Function(){

            @Override
            public void apply() throws Exception {
                ListProjectResult listProjectResult = ProjectExtensionTest.this.projectExtension.listProjects(ProjectAccess.BROWSE, null, null, null);
                Assert.assertEquals((int)6, (int)listProjectResult.getProjects().size());
                ListProjectResult excludedListProjectResult = ProjectExtensionTest.this.projectExtension.listProjects(ProjectAccess.BROWSE, null, null, (Set)Sets.newHashSet((Object[])new Long[]{((ProjectData)listProjectResult.getProjects().get(0)).getId()}));
                Assert.assertEquals((int)5, (int)excludedListProjectResult.getProjects().size());
                Assert.assertFalse((boolean)excludedListProjectResult.isMoreAvailable());
            }
        });
    }

    @Test
    public void testBaseRetrieval() throws Exception {
        this.withProjects(new Function(){

            @Override
            public void apply() throws Exception {
                ListProjectResult listProjectResult = ProjectExtensionTest.this.projectExtension.listProjects(ProjectAccess.BROWSE, null, null, null);
                Assert.assertEquals((int)6, (int)listProjectResult.getProjects().size());
                Assert.assertFalse((boolean)listProjectResult.isMoreAvailable());
                Assert.assertNotNull((Object)listProjectResult.getEpicIssueType());
                Assert.assertNotNull((Object)listProjectResult.getStoryPointsField());
                Assert.assertNotNull((Object)listProjectResult.getEpicLabelField());
                Assert.assertNotNull((Object)listProjectResult.getEpicLinkField());
                ProjectData fooAProject = (ProjectData)Iterables.find((Iterable)listProjectResult.getProjects(), (Predicate)new Predicate<ProjectData>(){

                    public boolean apply(@Nullable ProjectData projectData) {
                        return "FOOA".equals(projectData.getKey());
                    }
                });
                Assert.assertEquals((String)"FOOA", (String)fooAProject.getKey());
                Assert.assertEquals((String)"FOOA", (String)fooAProject.getName());
                ProjectData testDataProject = (ProjectData)Iterables.find((Iterable)listProjectResult.getProjects(), (Predicate)new Predicate<ProjectData>(){

                    public boolean apply(@Nullable ProjectData projectData) {
                        return "SCRUM".equals(projectData.getKey());
                    }
                });
                Assert.assertEquals((String)"SCRUM", (String)testDataProject.getKey());
                Assert.assertEquals((int)7, (int)testDataProject.getIssueTypes().size());
                Assert.assertEquals((String)"1", (String)((ProjectIssueTypeData)testDataProject.getIssueTypes().get(0)).getId());
                Assert.assertEquals((int)3, (int)((ProjectIssueTypeData)testDataProject.getIssueTypes().get(0)).getRequiredFields().size());
                Assert.assertTrue((boolean)((ProjectIssueTypeData)testDataProject.getIssueTypes().get(0)).getRequiredFields().contains("summary"));
                Assert.assertTrue((boolean)((ProjectIssueTypeData)testDataProject.getIssueTypes().get(0)).getRequiredFields().contains("issuetype"));
                Assert.assertTrue((boolean)((ProjectIssueTypeData)testDataProject.getIssueTypes().get(0)).getRequiredFields().contains("reporter"));
                Assert.assertEquals((int)7, (int)listProjectResult.getIssueTypes().size());
                IssueTypeData story = (IssueTypeData)listProjectResult.getIssueTypes().get(0);
                Assert.assertEquals((String)"10001", (String)story.getId());
                Assert.assertEquals((String)"Story", (String)story.getName());
                Assert.assertEquals((String)"Created by JIRA Agile - do not edit or delete. Issue type for a user story.", (String)story.getDescription());
                Assert.assertTrue((boolean)story.getIconUrl().startsWith("http://"));
                Assert.assertFalse((boolean)story.isSubTask());
                Assert.assertTrue((boolean)story.isStoryPointsEnabled());
            }
        });
    }

    @Test
    public void testLimitedRetrieval() throws Exception {
        this.withProjects(new Function(){

            @Override
            public void apply() throws Exception {
                ListProjectResult listProjectResult = ProjectExtensionTest.this.projectExtension.listProjects(ProjectAccess.BROWSE, null, Integer.valueOf(3), null);
                Assert.assertEquals((int)3, (int)listProjectResult.getProjects().size());
                Assert.assertTrue((boolean)listProjectResult.isMoreAvailable());
            }
        });
    }

    @Test
    public void testQueryStringRetrieval() throws Exception {
        this.withProjects(new Function(){

            @Override
            public void apply() throws Exception {
                ListProjectResult listProjectResult = ProjectExtensionTest.this.projectExtension.listProjects(ProjectAccess.BROWSE, "FOO", null, null);
                Assert.assertEquals((int)3, (int)listProjectResult.getProjects().size());
                Assert.assertFalse((boolean)listProjectResult.isMoreAvailable());
            }
        });
    }

    @Test
    public void testDefaultedProjectAccessWithoutDefault() throws Exception {
        this.withProjects(new Function(){

            @Override
            public void apply() throws Exception {
                ProjectService.GetProjectResult getProjectResult = ProjectExtensionTest.this.projectService.getProjectByKey(ProjectExtensionTest.this.user, "FOOA");
                ListProjectResult listProjectResult = ProjectExtensionTest.this.projectExtension.getDefaultedProject(ProjectAccess.BROWSE, getProjectResult.getProject().getId());
                Assert.assertEquals((int)1, (int)listProjectResult.getProjects().size());
                Assert.assertEquals((String)"FOOA", (String)((ProjectData)listProjectResult.getProjects().get(0)).getKey());
            }
        });
    }

    @Test
    public void testDefaultedProjectAccessWithDefault() throws Exception {
        this.withProjects(new Function(){

            @Override
            public void apply() throws Exception {
                ListProjectResult listProjectResult = ProjectExtensionTest.this.projectExtension.getDefaultedProject(ProjectAccess.BROWSE, TestData.Projects.NonExisting.ID);
                Assert.assertEquals((int)1, (int)listProjectResult.getProjects().size());
                Assert.assertEquals((String)"FOOA", (String)((ProjectData)listProjectResult.getProjects().get(0)).getKey());
            }
        });
    }

    @Test
    @Login(user=User.NON_ADMIN)
    public void testSecurityReadAccess() throws Exception {
        ListProjectResult listProjectResult = this.projectExtension.listProjects(ProjectAccess.BROWSE, null, null, null);
        Assert.assertEquals((int)2, (int)listProjectResult.getProjects().size());
    }

    @Test
    @Login(user=User.NON_ADMIN)
    public void testSecurityWriteAccess() throws Exception {
        ListProjectResult listProjectResult = this.projectExtension.listProjects(ProjectAccess.CREATE_ISSUES, null, null, null);
        Assert.assertEquals((int)1, (int)listProjectResult.getProjects().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withProjects(Function func) throws Exception {
        int i;
        String[] keys = new String[]{"FOOA", "FOOB", "FOOC"};
        try {
            for (i = 0; i < 3; ++i) {
                ProjectService.CreateProjectValidationResult createProjectValidationResult = this.projectService.validateCreateProject(this.user.getDirectoryUser(), keys[i], keys[i], keys[i], this.user.getDirectoryUser().getName(), "http://www.atlassian.com", null);
                this.projectService.createProject(createProjectValidationResult);
            }
            func.apply();
        }
        finally {
            for (i = 0; i < 3; ++i) {
                ProjectService.DeleteProjectValidationResult deleteValidationResult = this.projectService.validateDeleteProject(this.user, keys[i]);
                this.projectService.deleteProject(this.user, deleteValidationResult);
            }
        }
    }

    private static interface Function {
        public void apply() throws Exception;
    }
}

