/*
 * Decompiled with CFR 0.152.
 */
package it;

import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.plugins.osgi.test.AtlassianPluginsTestRunner;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.extensions.releases.ReleaseExtension;
import com.radiantminds.roadmap.common.extensions.releases.ReleaseExtensionDataRequest;
import com.radiantminds.roadmap.common.extensions.releases.ReleaseExtensionLinkData;
import com.radiantminds.roadmap.common.extensions.releases.ReleaseSyncResult;
import com.radiantminds.roadmap.common.extensions.releases.ReleasesExtensionData;
import com.radiantminds.roadmap.common.extensions.releases.VersionsBulkSyncRequest;
import com.radiantminds.roadmap.common.handlers.sync.releases.ValidReleaseSyncRequest;
import com.radiantminds.roadmap.common.handlers.sync.releases.VersionsBulkSyncRequestImpl;
import it.BaseIntegrationTest;
import it.login.Login;
import it.login.User;
import it.testdata.TestData;
import java.util.Date;
import java.util.Set;
import javax.annotation.Nonnull;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=AtlassianPluginsTestRunner.class)
public class ReleaseExtensionTest
extends BaseIntegrationTest {
    private static final String VERSION_NAME = "versionName";
    private static final String VERSION_DESCRIPTION = "versionDescription";
    private static final long START_INSTANT = 0L;
    private static final long RELEASE_INSTANT = 123234231234L;
    private final ReleaseExtension releaseExtension;
    private final VersionManager versionManager;

    public ReleaseExtensionTest(ReleaseExtension releaseExtension, VersionManager versionManager) {
        this.releaseExtension = releaseExtension;
        this.versionManager = versionManager;
    }

    @Test
    public void testNameUpdate() throws Exception {
        this.withProject(new BaseIntegrationTest.Function(){

            @Override
            public void apply(Project project) throws Exception {
                Version originalVersion = ReleaseExtensionTest.this.createDefaultVersion(project);
                VersionsBulkSyncRequestImpl request = new VersionsBulkSyncRequestImpl((Set)Sets.newHashSet((Object[])new String[]{originalVersion.getId().toString()}), ReleaseExtensionTest.createNameUpdate(), null, null, "versionNameversionName");
                ReleaseSyncResult result = ReleaseExtensionTest.this.releaseExtension.synchronizeReleaseData((VersionsBulkSyncRequest)request);
                Assert.assertTrue((boolean)result.getViolationMessages().isEmpty());
                Version resultVersion = ReleaseExtensionTest.this.versionManager.getVersion(originalVersion.getId());
                Assert.assertEquals((Object)"versionNameversionName", (Object)resultVersion.getName());
                ReleaseExtensionTest.this.assertStart(resultVersion.getStartDate().getTime());
                ReleaseExtensionTest.this.assertRelease(resultVersion.getReleaseDate().getTime());
            }
        });
    }

    private void assertRelease(long time) {
        Assert.assertTrue((time > 61617115617L ? 1 : 0) != 0);
    }

    private void assertStart(long time) {
        Assert.assertTrue((time < 61617115617L ? 1 : 0) != 0);
    }

    @Test
    public void testStartUpdate() throws Exception {
        this.withProject(new BaseIntegrationTest.Function(){

            @Override
            public void apply(Project project) throws Exception {
                Version originalVersion = ReleaseExtensionTest.this.createDefaultVersion(project);
                VersionsBulkSyncRequestImpl request = new VersionsBulkSyncRequestImpl((Set)Sets.newHashSet((Object[])new String[]{originalVersion.getId().toString()}), ReleaseExtensionTest.this.createStartUpdate(), Long.valueOf(123234231234L), null, null);
                ReleaseSyncResult result = ReleaseExtensionTest.this.releaseExtension.synchronizeReleaseData((VersionsBulkSyncRequest)request);
                Assert.assertTrue((boolean)result.getViolationMessages().isEmpty());
                Version resultVersion = ReleaseExtensionTest.this.versionManager.getVersion(originalVersion.getId());
                Assert.assertEquals((Object)ReleaseExtensionTest.VERSION_NAME, (Object)resultVersion.getName());
                ReleaseExtensionTest.this.assertRelease(resultVersion.getStartDate().getTime());
                ReleaseExtensionTest.this.assertRelease(resultVersion.getReleaseDate().getTime());
            }
        });
    }

    @Test
    public void testStartUpdateToNull() throws Exception {
        this.withProject(new BaseIntegrationTest.Function(){

            @Override
            public void apply(Project project) throws Exception {
                Version originalVersion = ReleaseExtensionTest.this.createDefaultVersion(project);
                VersionsBulkSyncRequestImpl request = new VersionsBulkSyncRequestImpl((Set)Sets.newHashSet((Object[])new String[]{originalVersion.getId().toString()}), ReleaseExtensionTest.this.createStartUpdate(), null, null, null);
                ReleaseSyncResult result = ReleaseExtensionTest.this.releaseExtension.synchronizeReleaseData((VersionsBulkSyncRequest)request);
                Assert.assertTrue((boolean)result.getViolationMessages().isEmpty());
                Version resultVersion = ReleaseExtensionTest.this.versionManager.getVersion(originalVersion.getId());
                Assert.assertEquals((Object)ReleaseExtensionTest.VERSION_NAME, (Object)resultVersion.getName());
                Assert.assertNull((Object)resultVersion.getStartDate());
                ReleaseExtensionTest.this.assertRelease(resultVersion.getReleaseDate().getTime());
            }
        });
    }

    @Test
    public void testEndUpdate() throws Exception {
        this.withProject(new BaseIntegrationTest.Function(){

            @Override
            public void apply(Project project) throws Exception {
                Version originalVersion = ReleaseExtensionTest.this.createDefaultVersion(project);
                VersionsBulkSyncRequestImpl request = new VersionsBulkSyncRequestImpl((Set)Sets.newHashSet((Object[])new String[]{originalVersion.getId().toString()}), ReleaseExtensionTest.this.createReleaseUpdate(), null, Long.valueOf(1L), null);
                ReleaseSyncResult result = ReleaseExtensionTest.this.releaseExtension.synchronizeReleaseData((VersionsBulkSyncRequest)request);
                Assert.assertTrue((boolean)result.getViolationMessages().isEmpty());
                Version resultVersion = ReleaseExtensionTest.this.versionManager.getVersion(originalVersion.getId());
                Assert.assertEquals((Object)ReleaseExtensionTest.VERSION_NAME, (Object)resultVersion.getName());
                ReleaseExtensionTest.this.assertStart(resultVersion.getStartDate().getTime());
                ReleaseExtensionTest.this.assertStart(resultVersion.getReleaseDate().getTime());
            }
        });
    }

    @Test
    public void testUpdateDuplicateVersionName() throws Exception {
        this.withProject(new BaseIntegrationTest.Function(){

            @Override
            public void apply(Project project) throws Exception {
                Version originalVersion = ReleaseExtensionTest.this.createDefaultVersion(project);
                VersionsBulkSyncRequestImpl request = new VersionsBulkSyncRequestImpl((Set)Sets.newHashSet((Object[])new String[]{originalVersion.getId().toString()}), ReleaseExtensionTest.createNameUpdate(), null, null, "versionNameversionName");
                ReleaseSyncResult result = ReleaseExtensionTest.this.releaseExtension.synchronizeReleaseData((VersionsBulkSyncRequest)request);
                Assert.assertTrue((boolean)result.getViolationMessages().isEmpty());
                Version resultVersion = ReleaseExtensionTest.this.versionManager.getVersion(originalVersion.getId());
                Assert.assertEquals((Object)"versionNameversionName", (Object)resultVersion.getName());
                ReleaseExtensionTest.this.assertStart(resultVersion.getStartDate().getTime());
                ReleaseExtensionTest.this.assertRelease(resultVersion.getReleaseDate().getTime());
            }
        });
    }

    @Test
    public void testReleaseUpdateToNull() throws Exception {
        this.withProject(new BaseIntegrationTest.Function(){

            @Override
            public void apply(Project project) throws Exception {
                Version originalVersion = ReleaseExtensionTest.this.createDefaultVersion(project);
                VersionsBulkSyncRequestImpl request = new VersionsBulkSyncRequestImpl((Set)Sets.newHashSet((Object[])new String[]{originalVersion.getId().toString()}), ReleaseExtensionTest.this.createReleaseUpdate(), null, null, null);
                ReleaseSyncResult result = ReleaseExtensionTest.this.releaseExtension.synchronizeReleaseData((VersionsBulkSyncRequest)request);
                Assert.assertTrue((boolean)result.getViolationMessages().isEmpty());
                Version resultVersion = ReleaseExtensionTest.this.versionManager.getVersion(originalVersion.getId());
                Assert.assertEquals((Object)ReleaseExtensionTest.VERSION_NAME, (Object)resultVersion.getName());
                Assert.assertNull((Object)resultVersion.getReleaseDate());
                ReleaseExtensionTest.this.assertStart(resultVersion.getStartDate().getTime());
            }
        });
    }

    @Test
    public void testNameUpdateWithDuplicateName() throws Exception {
        this.withProject(new BaseIntegrationTest.Function(){

            @Override
            public void apply(Project project) throws Exception {
                Version originalVersion = ReleaseExtensionTest.this.createDefaultVersion(project);
                Version blockingVersion = ReleaseExtensionTest.this.versionManager.createVersion("versionNameversionName", new Date(0L), new Date(123234231234L), ReleaseExtensionTest.VERSION_DESCRIPTION, project.getId(), null);
                VersionsBulkSyncRequestImpl request = new VersionsBulkSyncRequestImpl((Set)Sets.newHashSet((Object[])new String[]{originalVersion.getId().toString()}), ReleaseExtensionTest.createNameUpdate(), null, null, blockingVersion.getName());
                ReleaseSyncResult result = ReleaseExtensionTest.this.releaseExtension.synchronizeReleaseData((VersionsBulkSyncRequest)request);
                Assert.assertEquals((long)1L, (long)result.getViolationMessages().size());
                Version resultVersion = ReleaseExtensionTest.this.versionManager.getVersion(originalVersion.getId());
                Assert.assertEquals((Object)ReleaseExtensionTest.VERSION_NAME, (Object)resultVersion.getName());
                ReleaseExtensionTest.this.assertStart(resultVersion.getStartDate().getTime());
                ReleaseExtensionTest.this.assertRelease(resultVersion.getReleaseDate().getTime());
            }
        });
    }

    private Version createDefaultVersion(Project project) throws CreateException {
        return this.versionManager.createVersion(VERSION_NAME, new Date(0L), new Date(123234231234L), VERSION_DESCRIPTION, project.getId(), null);
    }

    private static ValidReleaseSyncRequest createNameUpdate() {
        ValidReleaseSyncRequest mock = (ValidReleaseSyncRequest)Mockito.mock(ValidReleaseSyncRequest.class);
        Mockito.when((Object)mock.isSyncName()).thenReturn((Object)true);
        return mock;
    }

    private ValidReleaseSyncRequest createStartUpdate() {
        ValidReleaseSyncRequest mock = (ValidReleaseSyncRequest)Mockito.mock(ValidReleaseSyncRequest.class);
        Mockito.when((Object)mock.isSyncStartDate()).thenReturn((Object)true);
        return mock;
    }

    private ValidReleaseSyncRequest createReleaseUpdate() {
        ValidReleaseSyncRequest mock = (ValidReleaseSyncRequest)Mockito.mock(ValidReleaseSyncRequest.class);
        Mockito.when((Object)mock.isSyncReleaseDate()).thenReturn((Object)true);
        return mock;
    }

    @Test
    public void testSuccessfulRetrieval() throws Exception {
        this.withProject(new BaseIntegrationTest.Function(){

            @Override
            public void apply(Project project) throws Exception {
                final Version originalVersion = ReleaseExtensionTest.this.createDefaultVersion(project);
                ReleaseExtensionDataRequest request = new ReleaseExtensionDataRequest(){

                    @Nonnull
                    public Set<String> getExtensionLinks() {
                        return Sets.newHashSet((Iterable)Sets.newHashSet((Object[])new String[]{originalVersion.getId().toString()}));
                    }
                };
                ReleasesExtensionData versions = ReleaseExtensionTest.this.releaseExtension.getReleasesExtensionData(request);
                ReleaseExtensionLinkData resultData = (ReleaseExtensionLinkData)versions.getEnrichtmentData().get(originalVersion.getId().toString());
                Assert.assertEquals((Object)"DPK", (Object)resultData.getProjectKey());
                Assert.assertEquals((Object)"dpk", (Object)resultData.getProjectName());
                Assert.assertEquals((Object)ReleaseExtensionTest.VERSION_DESCRIPTION, (Object)resultData.getVersionDescription());
                Assert.assertEquals((Object)ReleaseExtensionTest.VERSION_NAME, (Object)resultData.getVersionName());
                Assert.assertEquals((Object)originalVersion.getId().toString(), (Object)resultData.getLink());
            }
        });
    }

    @Test
    public void testUnknownVersionId() throws Exception {
        this.withProject(new BaseIntegrationTest.Function(){

            @Override
            public void apply(Project project) throws Exception {
                ReleaseExtensionTest.this.createDefaultVersion(project);
                ReleaseExtensionDataRequest request = new ReleaseExtensionDataRequest(){

                    @Nonnull
                    public Set<String> getExtensionLinks() {
                        return Sets.newHashSet((Iterable)Sets.newHashSet((Object[])new String[]{"99999"}));
                    }
                };
                ReleasesExtensionData versions = ReleaseExtensionTest.this.releaseExtension.getReleasesExtensionData(request);
                Assert.assertTrue((boolean)versions.getEnrichtmentData().isEmpty());
            }
        });
    }

    @Test
    public void testStringLink() throws Exception {
        this.withProject(new BaseIntegrationTest.Function(){

            @Override
            public void apply(Project project) throws Exception {
                ReleaseExtensionTest.this.createDefaultVersion(project);
                ReleaseExtensionDataRequest request = new ReleaseExtensionDataRequest(){

                    @Nonnull
                    public Set<String> getExtensionLinks() {
                        return Sets.newHashSet((Iterable)Sets.newHashSet((Object[])new String[]{"lnk"}));
                    }
                };
                ReleasesExtensionData versions = ReleaseExtensionTest.this.releaseExtension.getReleasesExtensionData(request);
                Assert.assertTrue((boolean)versions.getEnrichtmentData().isEmpty());
            }
        });
    }

    @Test
    public void testEmptyStringLinkSetIsOk() throws Exception {
        this.withProject(new BaseIntegrationTest.Function(){

            @Override
            public void apply(Project project) throws Exception {
                ReleaseExtensionTest.this.createDefaultVersion(project);
                ReleaseExtensionDataRequest request = new ReleaseExtensionDataRequest(){

                    @Nonnull
                    public Set<String> getExtensionLinks() {
                        return Sets.newHashSet((Iterable)Sets.newHashSet());
                    }
                };
                ReleasesExtensionData versions = ReleaseExtensionTest.this.releaseExtension.getReleasesExtensionData(request);
                Assert.assertTrue((boolean)versions.getEnrichtmentData().isEmpty());
            }
        });
    }

    @Test
    @Login(user=User.NON_ADMIN)
    public void testNonAdminGetsNoVersionInformation() throws Exception {
        ReleaseExtensionDataRequest request = new ReleaseExtensionDataRequest(){

            @Nonnull
            public Set<String> getExtensionLinks() {
                return Sets.newHashSet((Iterable)Sets.newHashSet((Object[])new String[]{TestData.Projects.InvisibleToNonAdmin.Versions.ID.toString()}));
            }
        };
        ReleasesExtensionData data = this.releaseExtension.getReleasesExtensionData(request);
        Assert.assertTrue((boolean)data.getEnrichtmentData().isEmpty());
    }

    @Test
    @Login(user=User.ADMIN)
    public void testAdminGetsVersionInformation() throws Exception {
        ReleaseExtensionDataRequest request = new ReleaseExtensionDataRequest(){

            @Nonnull
            public Set<String> getExtensionLinks() {
                return Sets.newHashSet((Iterable)Sets.newHashSet((Object[])new String[]{TestData.Projects.InvisibleToNonAdmin.Versions.ID.toString()}));
            }
        };
        ReleasesExtensionData data = this.releaseExtension.getReleasesExtensionData(request);
        Assert.assertEquals((long)1L, (long)data.getEnrichtmentData().size());
    }

    @Test
    @Login(user=User.NON_ADMIN)
    public void testNonAdminGetsNoVersionInformationForReadOnlyProject() throws Exception {
        ReleaseExtensionDataRequest request = new ReleaseExtensionDataRequest(){

            @Nonnull
            public Set<String> getExtensionLinks() {
                return Sets.newHashSet((Iterable)Sets.newHashSet((Object[])new String[]{TestData.Projects.ReadOnlyToNonAdmin.Versions.ID.toString()}));
            }
        };
        ReleasesExtensionData data = this.releaseExtension.getReleasesExtensionData(request);
        Assert.assertEquals((long)1L, (long)data.getEnrichtmentData().size());
    }
}

