/*
 * Decompiled with CFR 0.152.
 */
package it;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.plugins.osgi.test.AtlassianPluginsTestRunner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.extensions.projects.ProjectNotFoundException;
import com.radiantminds.roadmap.common.extensions.versions.CreateVersionPermissionException;
import com.radiantminds.roadmap.common.extensions.versions.CreateVersionRequest;
import com.radiantminds.roadmap.common.extensions.versions.ListVersionResult;
import com.radiantminds.roadmap.common.extensions.versions.VersionData;
import com.radiantminds.roadmap.common.extensions.versions.VersionExtension;
import it.BaseIntegrationTest;
import it.login.Login;
import it.login.User;
import it.testdata.TestData;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import junit.framework.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=AtlassianPluginsTestRunner.class)
public class VersionExtensionTest
extends BaseIntegrationTest {
    private final VersionExtension versionExtension;
    private final VersionManager versionManager;

    public VersionExtensionTest(VersionExtension versionExtension, VersionManager versionManager) {
        this.versionExtension = versionExtension;
        this.versionManager = versionManager;
    }

    @Test
    @Login(user=User.ADMIN)
    public void testCreateVersion() throws Exception {
        CreateVersionRequest request = new CreateVersionRequest(){

            public Long getProjectId() {
                return TestData.Projects.Scrum.ID;
            }

            public String getName() {
                return "Foo";
            }

            public String getDescription() {
                return "Desc";
            }

            public Long getStartDateUTC() {
                return null;
            }

            public Long getEndDateUTC() {
                return null;
            }
        };
        Long versionId = this.versionExtension.createVersion(request);
        Version persisted = this.versionManager.getVersion(versionId);
        Assert.assertEquals((String)"Foo", (String)persisted.getName());
        Assert.assertEquals((String)"Desc", (String)persisted.getDescription());
        Assert.assertEquals((Object)TestData.Projects.Scrum.ID, (Object)persisted.getProjectId());
    }

    @Test(expected=CreateVersionPermissionException.class)
    @Login(user=User.NON_ADMIN)
    public void testCreateVersionNoPermission() throws Exception {
        CreateVersionRequest request = new CreateVersionRequest(){

            public Long getProjectId() {
                return TestData.Projects.Scrum.ID;
            }

            public String getName() {
                return "Foo";
            }

            public String getDescription() {
                return "Desc";
            }

            public Long getStartDateUTC() {
                return null;
            }

            public Long getEndDateUTC() {
                return null;
            }
        };
        this.versionExtension.createVersion(request);
    }

    @Test(expected=ProjectNotFoundException.class)
    @Login(user=User.NON_ADMIN)
    public void testCreateVersionNoProject() throws Exception {
        CreateVersionRequest request = new CreateVersionRequest(){

            public Long getProjectId() {
                return TestData.Projects.NonExisting.ID;
            }

            public String getName() {
                return "Foo";
            }

            public String getDescription() {
                return "Desc";
            }

            public Long getStartDateUTC() {
                return null;
            }

            public Long getEndDateUTC() {
                return null;
            }
        };
        this.versionExtension.createVersion(request);
    }

    @Test
    public void testExcluded() throws Exception {
        this.withProject(new BaseIntegrationTest.Function(){

            @Override
            public void apply(Project project) throws Exception {
                ArrayList created = Lists.newArrayList();
                for (int i = 0; i < 45; ++i) {
                    Version version = VersionExtensionTest.this.versionManager.createVersion("Version " + i, null, "Foo", project.getId(), null);
                    created.add(version);
                }
                ListVersionResult versions = VersionExtensionTest.this.versionExtension.findVersions(project.getId(), null, (Set)Sets.newHashSet((Object[])new Long[]{((Version)created.get(17)).getId(), ((Version)created.get(21)).getId(), ((Version)created.get(42)).getId()}), Integer.valueOf(100));
                Assert.assertEquals((int)42, (int)versions.getVersions().size());
                Assert.assertFalse((boolean)versions.isMoreAvailable());
            }
        });
    }

    @Test
    public void testBaseRetrieval() throws Exception {
        this.withProject(new BaseIntegrationTest.Function(){

            @Override
            public void apply(Project project) throws Exception {
                Version originalVersion = VersionExtensionTest.this.versionManager.createVersion("Name", new Date(0L), new Date(1L), "Description", project.getId(), null);
                ListVersionResult versions = VersionExtensionTest.this.versionExtension.findVersions(project.getId(), null, null, Integer.valueOf(100));
                Assert.assertEquals((int)1, (int)versions.getVersions().size());
                Assert.assertFalse((boolean)versions.isMoreAvailable());
                VersionData version = (VersionData)versions.getVersions().get(0);
                Assert.assertEquals((Object)originalVersion.getId(), (Object)version.getId());
                Assert.assertEquals((String)"Name", (String)version.getName());
                Assert.assertEquals((String)"Description", (String)version.getDescription());
                Assert.assertEquals((Object)new Date(0L), (Object)version.getStartDate());
                Assert.assertEquals((Object)new Date(1L), (Object)version.getReleaseDate());
            }
        });
    }

    @Test
    public void testLimitNoSearchTerm() throws Exception {
        this.withProject(new BaseIntegrationTest.Function(){

            @Override
            public void apply(Project project) throws Exception {
                for (int i = 0; i < 51; ++i) {
                    VersionExtensionTest.this.versionManager.createVersion("Version " + i, null, "Foo", project.getId(), null);
                }
                ListVersionResult versions = VersionExtensionTest.this.versionExtension.findVersions(project.getId(), null, null, Integer.valueOf(50));
                Assert.assertEquals((int)50, (int)versions.getVersions().size());
                Assert.assertTrue((boolean)versions.isMoreAvailable());
            }
        });
    }

    @Test
    public void testLimitWithSearchTerm() throws Exception {
        this.withProject(new BaseIntegrationTest.Function(){

            @Override
            public void apply(Project project) throws Exception {
                for (int i = 0; i < 51; ++i) {
                    VersionExtensionTest.this.versionManager.createVersion("Version " + i, null, "Foo", project.getId(), null);
                }
                ListVersionResult versions = VersionExtensionTest.this.versionExtension.findVersions(project.getId(), "Version", null, Integer.valueOf(50));
                Assert.assertEquals((int)50, (int)versions.getVersions().size());
                Assert.assertTrue((boolean)versions.isMoreAvailable());
            }
        });
    }

    @Test
    public void testSearchTerm() throws Exception {
        this.withProject(new BaseIntegrationTest.Function(){

            @Override
            public void apply(Project project) throws Exception {
                VersionExtensionTest.this.versionManager.createVersion("foo", null, "bar", project.getId(), null);
                VersionExtensionTest.this.versionManager.createVersion("bar", null, "foo", project.getId(), null);
                VersionExtensionTest.this.versionManager.createVersion("bang", null, "bang", project.getId(), null);
                ListVersionResult versions = VersionExtensionTest.this.versionExtension.findVersions(project.getId(), "foo", null, Integer.valueOf(100));
                Assert.assertEquals((int)1, (int)versions.getVersions().size());
                Assert.assertFalse((boolean)versions.isMoreAvailable());
            }
        });
    }

    @Test
    public void testNonExistingRetrieval() throws Exception {
        ListVersionResult versions = this.versionExtension.findVersions(TestData.Projects.NonExisting.ID, null, null, Integer.valueOf(100));
        Assert.assertEquals((int)0, (int)versions.getVersions().size());
    }

    @Test
    @Login(user=User.NON_ADMIN)
    public void testReadOnlyAccessRetrieval() throws Exception {
        ListVersionResult versions = this.versionExtension.findVersions(TestData.Projects.ReadOnlyToNonAdmin.ID, null, null, Integer.valueOf(100));
        Assert.assertEquals((int)1, (int)versions.getVersions().size());
    }

    @Test
    @Login(user=User.NON_ADMIN)
    public void testInvisibleAccessRetrieval() throws Exception {
        ListVersionResult versions = this.versionExtension.findVersions(TestData.Projects.InvisibleToNonAdmin.ID, null, null, Integer.valueOf(100));
        Assert.assertEquals((int)0, (int)versions.getVersions().size());
    }

    @Test
    public void testInvisibleAccessRetrievalForAdmin() throws Exception {
        ListVersionResult versions = this.versionExtension.findVersions(TestData.Projects.InvisibleToNonAdmin.ID, null, null, Integer.valueOf(100));
        Assert.assertEquals((int)1, (int)versions.getVersions().size());
    }
}

