/*
 * Decompiled with CFR 0.152.
 */
package it;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jpo.agile.api.license.AgileLicenseServiceBridge;
import com.atlassian.jpo.agile.api.license.AgileLicenseServiceBridgeProxy;
import com.atlassian.jpo.agile.api.project.AgileProjectServiceBridge;
import com.atlassian.jpo.agile.api.project.AgileProjectServiceBridgeProxy;
import com.atlassian.jpo.jira.api.issue.IssueServiceBridge;
import com.atlassian.jpo.jira.api.issue.IssueServiceBridgeProxy;
import com.atlassian.jpo.jira.api.login.LoginServiceBridge;
import com.atlassian.jpo.jira.api.login.LoginServiceBridgeProxy;
import com.atlassian.jpo.jira.api.project.ProjectCreationData;
import com.atlassian.jpo.jira.api.project.ProjectServiceBridge;
import com.atlassian.jpo.jira.api.project.ProjectServiceBridgeProxy;
import com.atlassian.jpo.jira.api.scheme.SchemeEntityTypeUtilsBridge;
import com.atlassian.jpo.jira.api.scheme.SchemeEntityTypeUtilsBridgeProxy;
import com.atlassian.jpo.jira.api.user.UserServiceBridge;
import com.atlassian.jpo.jira.api.user.UserServiceBridgeProxy;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.login.Login;
import it.login.ProjectCreationLogin;
import it.login.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class BaseIntegrationTest {
    protected static final String DEFAULT_PROJECT_NAME = "dpk";
    protected static final String DEFAULT_PROJECT_KEY = "DPK";
    private static final String ID_FIELD = "id";
    private final JiraAuthenticationContext authenticationContext;
    private final UserManager userManager;
    private final ProjectService projectService;
    private final IssueSecuritySchemeManager securitySchemeManager;
    private final PermissionSchemeManager permissionSchemeManager;
    private final IssueService issueService;
    private final ProjectRoleService projectRoleService;
    private final VersionManager versionManager;
    private final LoginServiceBridgeProxy loginServiceBridgeProxy;
    private final SchemeEntityTypeUtilsBridgeProxy schemeEntityTypeUtilsBridgeProxy;
    private final ProjectServiceBridgeProxy projectServiceBridgeProxy;
    private final IssueServiceBridgeProxy issueServiceBridgeProxy;
    private final UserServiceBridgeProxy userServiceBridgeProxy;
    private final AgileProjectServiceBridgeProxy agileProjectBridgeProxy;
    private final AgileLicenseServiceBridgeProxy agileLicenseBridgeProxy;
    private Project invisibleToNonAdminProject;
    private Project readOnlyToNonAdminProject;
    private Project scrumProject;
    private Version invisibleToNonAdminProjectVersion;
    private Version readOnlyToNonAdminProjectVersion;
    private Scheme restrictedScheme;
    private User baseUser;
    private User projectCreationUser;
    private ApplicationUser user;
    @Rule
    public TestRule watchman = new TestWatcher(){

        protected void starting(Description description) {
            Login login = (Login)description.getAnnotation(Login.class);
            BaseIntegrationTest.this.baseUser = login != null ? login.user() : User.ADMIN;
            ProjectCreationLogin projectCreationLogin = (ProjectCreationLogin)description.getAnnotation(ProjectCreationLogin.class);
            BaseIntegrationTest.this.projectCreationUser = projectCreationLogin != null ? projectCreationLogin.user() : BaseIntegrationTest.this.baseUser;
            BaseIntegrationTest.this.login(BaseIntegrationTest.this.baseUser);
        }
    };

    public BaseIntegrationTest(ProjectServiceBridgeProxy projectServiceBridgeProxy, LoginServiceBridgeProxy loginServiceBridgeProxy, IssueServiceBridgeProxy issueServiceBridgeProxy, UserServiceBridgeProxy userServiceBridgeProxy, SchemeEntityTypeUtilsBridgeProxy schemeEntityTypeUtilsBridgeProxy, AgileProjectServiceBridgeProxy agileProjectBridgeProxy, AgileLicenseServiceBridgeProxy agileLicenseBridgeProxy) {
        this.loginServiceBridgeProxy = loginServiceBridgeProxy;
        this.projectServiceBridgeProxy = projectServiceBridgeProxy;
        this.issueServiceBridgeProxy = issueServiceBridgeProxy;
        this.userServiceBridgeProxy = userServiceBridgeProxy;
        this.schemeEntityTypeUtilsBridgeProxy = schemeEntityTypeUtilsBridgeProxy;
        this.agileProjectBridgeProxy = agileProjectBridgeProxy;
        this.agileLicenseBridgeProxy = agileLicenseBridgeProxy;
        this.authenticationContext = ComponentAccessor.getJiraAuthenticationContext();
        this.userManager = ComponentAccessor.getUserManager();
        this.permissionSchemeManager = ComponentAccessor.getPermissionSchemeManager();
        this.issueService = ComponentAccessor.getIssueService();
        this.versionManager = ComponentAccessor.getVersionManager();
        this.projectRoleService = (ProjectRoleService)ComponentAccessor.getComponent(ProjectRoleService.class);
        this.projectService = (ProjectService)ComponentAccessor.getComponent(ProjectService.class);
        this.securitySchemeManager = (IssueSecuritySchemeManager)ComponentAccessor.getComponent(IssueSecuritySchemeManager.class);
    }

    @BeforeClass
    public void setUp() throws Exception {
        this.createNonAdminUser();
        this.login(User.ADMIN);
        this.restrictedScheme = this.createRestrictedPermissions();
        this.invisibleToNonAdminProject = this.createInvisibleToNonAdminProject();
        this.readOnlyToNonAdminProject = this.createReadOnlyToNonAdminProject();
        this.scrumProject = this.createScrumProject();
        ((AgileLicenseServiceBridge)this.agileLicenseBridgeProxy.get()).setCheckEnabled(false);
    }

    @AfterClass
    public void tearDown() throws Exception {
        this.deleteProjectAsAdmin(this.invisibleToNonAdminProject);
        this.deleteProjectAsAdmin(this.readOnlyToNonAdminProject);
        this.deleteProjectAsAdmin(this.scrumProject);
        this.deleteNonAdminUser();
        this.deleteScheme(this.restrictedScheme);
        ((AgileLicenseServiceBridge)this.agileLicenseBridgeProxy.get()).setCheckEnabled(true);
    }

    private void createNonAdminUser() throws Exception {
        UserService.CreateUserValidationResult createUserValidationResult = ((UserServiceBridge)this.userServiceBridgeProxy.get()).validateCreateUserForSetup(this.user, User.NON_ADMIN.getUsername(), User.NON_ADMIN.getPassword(), User.NON_ADMIN.getPassword(), "nonadmin@nonadmin.com", User.NON_ADMIN.getUsername());
        ((UserServiceBridge)this.userServiceBridgeProxy.get()).createUserNoNotification(createUserValidationResult);
    }

    private void deleteNonAdminUser() {
        UserService.DeleteUserValidationResult deleteUserValidationResult = ((UserServiceBridge)this.userServiceBridgeProxy.get()).validateDeleteUser(this.user, User.NON_ADMIN.getUsername());
        ((UserServiceBridge)this.userServiceBridgeProxy.get()).removeUser(this.user, deleteUserValidationResult);
    }

    private void login(User user) {
        ApplicationUser applicationUser = this.userManager.getUserByName(user.getUsername());
        ((LoginServiceBridge)this.loginServiceBridgeProxy.get()).authenticate(applicationUser, user.getPassword());
        this.authenticationContext.setLoggedInUser(applicationUser);
        ((LoginServiceBridge)this.loginServiceBridgeProxy.get()).authenticate(this.authenticationContext.getUser(), user.getPassword());
        this.user = this.authenticationContext.getUser();
    }

    private Project createDefaultProject() throws Exception {
        return this.createTestProject(DEFAULT_PROJECT_NAME, DEFAULT_PROJECT_KEY);
    }

    private Project createInvisibleToNonAdminProject() throws Exception {
        Project project = this.createTestProject("Invisible to Non-Admin", "ITNA");
        this.invisibleToNonAdminProjectVersion = this.addVersionToProject(project);
        this.setInvisiblePermissions(project);
        return project;
    }

    private Project createReadOnlyToNonAdminProject() throws Exception {
        Project project = this.createTestProject("Readonly to Non-Admin", "RTNA");
        this.readOnlyToNonAdminProjectVersion = this.addVersionToProject(project);
        this.associateSchemeWithProject(project, this.restrictedScheme);
        return project;
    }

    private void associateSchemeWithProject(Project project, Scheme scheme) {
        this.permissionSchemeManager.removeSchemesFromProject(project);
        this.permissionSchemeManager.addSchemeToProject(project, scheme);
    }

    private Scheme createRestrictedPermissions() {
        Scheme defaultScheme = this.permissionSchemeManager.getDefaultSchemeObject();
        Iterable entities = Iterables.transform((Iterable)defaultScheme.getEntities(), (com.google.common.base.Function)new com.google.common.base.Function<SchemeEntity, SchemeEntity>(){

            public SchemeEntity apply(SchemeEntity input) {
                return new SchemeEntity(input.getType(), input.getParameter(), input.getEntityTypeId());
            }
        });
        ((SchemeEntityTypeUtilsBridge)this.schemeEntityTypeUtilsBridgeProxy.get()).removeCreateIssuePermission(entities);
        ArrayList schemeEntityList = Lists.newArrayList((Iterable)entities);
        ((SchemeEntityTypeUtilsBridge)this.schemeEntityTypeUtilsBridgeProxy.get()).addCreateIssuePermissionForDevelopers((List)schemeEntityList);
        Scheme permissionScheme = new Scheme(null, "PermissionScheme", "Restricted Scheme", "Restricted scheme that gives Create Issue permissions only to Developers.", (Collection)schemeEntityList);
        Scheme createdPermissionScheme = this.permissionSchemeManager.createSchemeAndEntities(permissionScheme);
        return createdPermissionScheme;
    }

    private void deleteScheme(Scheme scheme) throws Exception {
        this.permissionSchemeManager.deleteScheme(scheme.getId());
    }

    private Project createScrumProject() throws Exception {
        Project agileProject = ((AgileProjectServiceBridge)this.agileProjectBridgeProxy.get()).createScrumProject(this.user, "scrum", "SCRUM", "scrum project", "admin", null, null, null);
        ApplicationUser admin = this.userManager.getUserByName("admin");
        this.createIssueInProject(agileProject, admin);
        this.createIssueInProject(agileProject, admin);
        this.createIssueInProject(agileProject, admin);
        return agileProject;
    }

    private Project createTestProject(String name, String key) throws Exception {
        ProjectCreationData projectCreationData = new ProjectCreationData.Builder().withName(name).withKey(key).withDescription("Foo").withLead(this.user).withUrl("http://www.atlassian.com").build();
        ProjectService.CreateProjectValidationResult createProjectValidationResult = ((ProjectServiceBridge)this.projectServiceBridgeProxy.get()).validateCreateProject(this.user, projectCreationData);
        Project project = this.projectService.createProject(createProjectValidationResult);
        ProjectService.UpdateProjectSchemesValidationResult schemeValidationResult = this.projectService.validateUpdateProjectSchemes(this.user, this.getPermissionSchemeId(), null, this.getSecuritySchemeId());
        this.projectService.updateProjectSchemes(schemeValidationResult, project);
        return project;
    }

    private void deleteProjectAsAdmin(Project project) {
        this.login(User.ADMIN);
        ProjectService.DeleteProjectValidationResult deleteValidationResult = this.projectService.validateDeleteProject(this.user, project.getKey());
        this.projectService.deleteProject(this.user, deleteValidationResult);
    }

    private Version addVersionToProject(Project project) throws Exception {
        return this.versionManager.createVersion("X", null, "Description", project.getId(), null);
    }

    private void setInvisiblePermissions(Project project) {
        SimpleErrorCollection getRolesErrors = new SimpleErrorCollection();
        ProjectRole usersRole = this.projectRoleService.getProjectRoleByName("Users", (ErrorCollection)getRolesErrors);
        HashSet usersGroup = Sets.newHashSet((Object[])new String[]{"jira-users"});
        SimpleErrorCollection removeActorsErrors = new SimpleErrorCollection();
        this.projectRoleService.removeActorsFromProjectRole((Collection)usersGroup, usersRole, project, "atlassian-group-role-actor", (ErrorCollection)removeActorsErrors);
        SimpleErrorCollection addActorsErrors = new SimpleErrorCollection();
        HashSet adminsGroup = Sets.newHashSet((Object[])new String[]{"jira-administrators"});
        this.projectRoleService.addActorsToProjectRole((Collection)adminsGroup, usersRole, project, "atlassian-group-role-actor", (ErrorCollection)addActorsErrors);
    }

    private Issue createIssueInProject(Project project, ApplicationUser reporter) {
        IssueInputParameters issueInputParameters = this.issueService.newIssueInputParameters().setProjectId(project.getId()).setIssueTypeId("1").setSummary("Wat").setReporterId(reporter.getName()).setAssigneeId(reporter.getName());
        IssueService.CreateValidationResult createValidationResult = ((IssueServiceBridge)this.issueServiceBridgeProxy.get()).validateCreate(this.user, issueInputParameters);
        IssueService.IssueResult issueResult = ((IssueServiceBridge)this.issueServiceBridgeProxy.get()).create(this.user, createValidationResult);
        return issueResult.getIssue();
    }

    protected Long getProjectId(TestProjects project) {
        switch (project) {
            case INVISIBLE_TO_NON_ADMIN_PROJECT: {
                return this.invisibleToNonAdminProject.getId();
            }
            case READ_ONLY_TO_NON_ADMIN_PROJECT: {
                return this.readOnlyToNonAdminProject.getId();
            }
            case SCRUM_PROJECT: {
                return this.scrumProject.getId();
            }
        }
        throw new IllegalArgumentException();
    }

    protected Version getProjectVersion(TestProjects project) {
        switch (project) {
            case INVISIBLE_TO_NON_ADMIN_PROJECT: {
                return this.invisibleToNonAdminProjectVersion;
            }
            case READ_ONLY_TO_NON_ADMIN_PROJECT: {
                return this.readOnlyToNonAdminProjectVersion;
            }
        }
        throw new IllegalArgumentException();
    }

    protected ApplicationUser getCurrentUser() {
        return this.user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void withProject(Function test) throws Exception {
        if (this.projectService == null) {
            throw new Exception("Project service not available.");
        }
        Project project = null;
        try {
            project = this.createTestProject();
            test.apply(project);
        }
        finally {
            this.deleteProject(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Project createTestProject() throws Exception {
        try {
            this.loginAsProjectCreationUser();
            Project project = this.createDefaultProject();
            return project;
        }
        finally {
            this.loginAsBaseUser();
        }
    }

    private void loginAsProjectCreationUser() {
        if (this.baseUser != this.projectCreationUser) {
            this.login(this.projectCreationUser);
        }
    }

    private void loginAsBaseUser() {
        if (this.baseUser != this.projectCreationUser) {
            this.login(this.baseUser);
        }
    }

    private void deleteProject(Project project) {
        this.loginAsProjectCreationUser();
        if (project != null) {
            ProjectService.DeleteProjectValidationResult deleteValidationResult = this.projectService.validateDeleteProject(this.user, project.getKey());
            this.projectService.deleteProject(this.user, deleteValidationResult);
        }
        this.loginAsBaseUser();
    }

    private Long getSecuritySchemeId() throws GenericEntityException {
        GenericValue defaultScheme = this.securitySchemeManager.getDefaultScheme();
        return BaseIntegrationTest.getLong(defaultScheme, ID_FIELD);
    }

    private Long getPermissionSchemeId() throws GenericEntityException {
        GenericValue defaultScheme = this.permissionSchemeManager.getDefaultScheme();
        return BaseIntegrationTest.getLong(defaultScheme, ID_FIELD);
    }

    private static Long getLong(GenericValue gv, String fieldName) {
        if (gv == null) {
            return null;
        }
        Object o = gv.get(fieldName);
        if (o == null) {
            return null;
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Integer) {
            return (long)((Integer)o);
        }
        if (o instanceof String) {
            try {
                return Long.valueOf((String)o);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    protected static interface Function {
        public void apply(Project var1) throws Exception;
    }

    protected static enum TestProjects {
        INVISIBLE_TO_NON_ADMIN_PROJECT,
        READ_ONLY_TO_NON_ADMIN_PROJECT,
        SCRUM_PROJECT;

    }
}

