/*
 * Decompiled with CFR 0.152.
 */
package it;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jpo.agile.api.license.AgileLicenseServiceBridge;
import com.atlassian.jpo.agile.api.license.AgileLicenseServiceBridgeProxy;
import com.atlassian.jpo.agile.api.project.AgileProjectServiceBridgeProxy;
import com.atlassian.jpo.jira.api.issue.IssueServiceBridgeProxy;
import com.atlassian.jpo.jira.api.login.LoginServiceBridgeProxy;
import com.atlassian.jpo.jira.api.project.ProjectServiceBridgeProxy;
import com.atlassian.jpo.jira.api.scheme.SchemeEntityTypeUtilsBridgeProxy;
import com.atlassian.jpo.jira.api.user.UserServiceBridgeProxy;
import it.login.User;
import it.testdata.BaseProject;
import it.testdata.DefaultProject;
import it.testdata.InvisibleToNonAdminProject;
import it.testdata.ReadOnlyToNonAdminProject;
import it.testdata.ScrumProject;
import it.testutils.IssueUtils;
import it.testutils.PermissionUtils;
import it.testutils.ProjectRoleUtils;
import it.testutils.ProjectUtils;
import it.testutils.UserSwitcher;
import it.testutils.UserUtils;
import it.testutils.VersionUtils;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class BaseIntegrationTest {
    private static final int PROJECT_COUNT = 3;
    private final AgileLicenseServiceBridgeProxy agileLicenseBridgeProxy;
    private final IssueUtils issueUtils;
    private final PermissionUtils permissionUtils;
    private final ProjectRoleUtils projectRoleUtils;
    private final ProjectUtils projectUtils;
    private final UserSwitcher userSwitcher;
    private final UserUtils userUtils;
    private final VersionUtils versionUtils;
    protected InvisibleToNonAdminProject invisibleToNonAdminProject;
    protected ReadOnlyToNonAdminProject readOnlyToNonAdminProject;
    protected ScrumProject scrumProject;
    @Rule
    public TestRule testWatcher = new TestWatcher(){

        protected void starting(Description usersDescription) {
            BaseIntegrationTest.this.userSwitcher.configureUsersForTest(usersDescription);
        }
    };

    public BaseIntegrationTest() {
        AgileProjectServiceBridgeProxy agileProjectBridgeProxy = (AgileProjectServiceBridgeProxy)ComponentAccessor.getOSGiComponentInstanceOfType(AgileProjectServiceBridgeProxy.class);
        IssueService issueService = ComponentAccessor.getIssueService();
        IssueServiceBridgeProxy issueServiceBridgeProxy = (IssueServiceBridgeProxy)ComponentAccessor.getOSGiComponentInstanceOfType(IssueServiceBridgeProxy.class);
        JiraAuthenticationContext authenticationContext = ComponentAccessor.getJiraAuthenticationContext();
        LoginServiceBridgeProxy loginServiceBridgeProxy = (LoginServiceBridgeProxy)ComponentAccessor.getOSGiComponentInstanceOfType(LoginServiceBridgeProxy.class);
        PermissionSchemeManager permissionSchemeManager = ComponentAccessor.getPermissionSchemeManager();
        ProjectRoleService projectRoleService = (ProjectRoleService)ComponentAccessor.getComponent(ProjectRoleService.class);
        ProjectService projectService = (ProjectService)ComponentAccessor.getComponent(ProjectService.class);
        ProjectServiceBridgeProxy projectServiceBridgeProxy = (ProjectServiceBridgeProxy)ComponentAccessor.getOSGiComponentInstanceOfType(ProjectServiceBridgeProxy.class);
        SchemeEntityTypeUtilsBridgeProxy schemeEntityTypeUtilsBridgeProxy = (SchemeEntityTypeUtilsBridgeProxy)ComponentAccessor.getOSGiComponentInstanceOfType(SchemeEntityTypeUtilsBridgeProxy.class);
        UserManager userManager = ComponentAccessor.getUserManager();
        UserServiceBridgeProxy userServiceBridgeProxy = (UserServiceBridgeProxy)ComponentAccessor.getOSGiComponentInstanceOfType(UserServiceBridgeProxy.class);
        VersionManager versionManager = ComponentAccessor.getVersionManager();
        this.agileLicenseBridgeProxy = (AgileLicenseServiceBridgeProxy)ComponentAccessor.getOSGiComponentInstanceOfType(AgileLicenseServiceBridgeProxy.class);
        this.issueUtils = new IssueUtils(issueService, issueServiceBridgeProxy);
        this.permissionUtils = new PermissionUtils(permissionSchemeManager, schemeEntityTypeUtilsBridgeProxy);
        this.projectRoleUtils = new ProjectRoleUtils(projectRoleService);
        this.projectUtils = new ProjectUtils(agileProjectBridgeProxy, projectServiceBridgeProxy, projectService);
        this.userSwitcher = new UserSwitcher(userManager, loginServiceBridgeProxy, authenticationContext);
        this.userUtils = new UserUtils(userServiceBridgeProxy, userManager);
        this.versionUtils = new VersionUtils(versionManager);
    }

    @BeforeClass
    public void setUp() throws Exception {
        ((AgileLicenseServiceBridge)this.agileLicenseBridgeProxy.get()).setCheckEnabled(false);
        this.userSwitcher.login(User.ADMIN);
        this.userUtils.createUser(User.NON_ADMIN, this.getCurrentUser());
        this.invisibleToNonAdminProject = new InvisibleToNonAdminProject(this.projectUtils, this.versionUtils, this.projectRoleUtils, this.getCurrentUser());
        this.readOnlyToNonAdminProject = new ReadOnlyToNonAdminProject(this.projectUtils, this.versionUtils, this.permissionUtils, this.getCurrentUser());
        this.scrumProject = new ScrumProject(this.projectUtils, this.userUtils, this.issueUtils, this.getCurrentUser());
    }

    @AfterClass
    public void tearDown() throws Exception {
        this.userSwitcher.login(User.ADMIN);
        this.scrumProject.delete();
        this.readOnlyToNonAdminProject.delete();
        this.invisibleToNonAdminProject.delete();
        this.userUtils.deleteUser(User.NON_ADMIN, this.getCurrentUser());
        ((AgileLicenseServiceBridge)this.agileLicenseBridgeProxy.get()).setCheckEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void withProject(Function test) throws Exception {
        BaseProject project = null;
        try {
            this.userSwitcher.loginAsProjectCreationUser();
            project = new DefaultProject(this.projectUtils, this.getCurrentUser());
            this.userSwitcher.loginAsBaseUser();
            test.apply(((DefaultProject)project).getProject());
        }
        finally {
            if (project != null) {
                project.delete();
            }
        }
    }

    protected int getProjectCount() {
        return 3;
    }

    protected ApplicationUser getCurrentUser() {
        return this.userSwitcher.getCurrentUser();
    }

    protected static interface Function {
        public void apply(Project var1) throws Exception;
    }
}

