/*
 * Decompiled with CFR 0.152.
 */
package it.testutils;

import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jpo.jira.api.user.UserServiceBridge;
import com.atlassian.jpo.jira.api.user.UserServiceBridgeProxy;
import it.login.User;

public class UserUtils {
    private final UserServiceBridgeProxy userServiceBridgeProxy;
    private final UserManager userManager;

    public UserUtils(UserServiceBridgeProxy userServiceBridgeProxy, UserManager userManager) {
        this.userServiceBridgeProxy = userServiceBridgeProxy;
        this.userManager = userManager;
    }

    public ApplicationUser getAdminUser() {
        return this.userManager.getUserByName(User.ADMIN.getUsername());
    }

    public void createUser(User user, ApplicationUser loggedInUser) throws Exception {
        UserService.CreateUserValidationResult createUserValidationResult = ((UserServiceBridge)this.userServiceBridgeProxy.get()).validateCreateUserForSetup(loggedInUser, user.getUsername(), user.getPassword(), user.getPassword(), user.getUsername() + "@atlassian.com", user.getUsername());
        if (createUserValidationResult.isValid()) {
            ((UserServiceBridge)this.userServiceBridgeProxy.get()).createUserNoNotification(createUserValidationResult);
        }
    }

    public void deleteUser(User user, ApplicationUser loggedInUser) {
        UserService.DeleteUserValidationResult deleteUserValidationResult = ((UserServiceBridge)this.userServiceBridgeProxy.get()).validateDeleteUser(loggedInUser, user.getUsername());
        if (deleteUserValidationResult.isValid()) {
            ((UserServiceBridge)this.userServiceBridgeProxy.get()).removeUser(loggedInUser, deleteUserValidationResult);
        }
    }
}

