/*
 * Decompiled with CFR 0.152.
 */
package it.testdata;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.user.ApplicationUser;
import it.testdata.BaseProject;
import it.testutils.PermissionUtils;
import it.testutils.ProjectUtils;
import it.testutils.VersionUtils;

public class ReadOnlyToNonAdminProject
extends BaseProject {
    private final Project project;
    private final Scheme restrictedPermissionsScheme;
    private final PermissionUtils permissionUtils;

    public ReadOnlyToNonAdminProject(ProjectUtils projectUtils, VersionUtils versionUtils, PermissionUtils permissionUtils, ApplicationUser leadUser) throws Exception {
        super(projectUtils);
        this.permissionUtils = permissionUtils;
        this.project = projectUtils.createNormalProject(leadUser, "Readonly to Non-Admin", "RTNA");
        versionUtils.createVersionInProject("X", this.project);
        this.restrictedPermissionsScheme = this.permissionUtils.createRestrictedPermissionsScheme();
        this.permissionUtils.addSchemeToProject(this.project, this.restrictedPermissionsScheme);
    }

    @Override
    public void delete() throws Exception {
        this.permissionUtils.removeSchemesFromProject(this.project);
        this.permissionUtils.deletePermissionsScheme(this.restrictedPermissionsScheme);
        super.delete();
    }

    @Override
    public Project getProject() {
        return this.project;
    }
}

