/*
 * Decompiled with CFR 0.152.
 */
package it.testutils;

import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jpo.agile.api.project.AgileProjectServiceBridge;
import com.atlassian.jpo.agile.api.project.AgileProjectServiceBridgeProxy;
import com.atlassian.jpo.jira.api.project.ProjectCreationData;
import com.atlassian.jpo.jira.api.project.ProjectServiceBridge;
import com.atlassian.jpo.jira.api.project.ProjectServiceBridgeProxy;

public class ProjectUtils {
    private final AgileProjectServiceBridgeProxy agileProjectBridgeProxy;
    private final ProjectServiceBridgeProxy projectServiceBridgeProxy;
    private final ProjectService projectService;

    public ProjectUtils(AgileProjectServiceBridgeProxy agileProjectBridgeProxy, ProjectServiceBridgeProxy projectServiceBridgeProxy, ProjectService projectService) {
        this.agileProjectBridgeProxy = agileProjectBridgeProxy;
        this.projectServiceBridgeProxy = projectServiceBridgeProxy;
        this.projectService = projectService;
    }

    public Project createNormalProject(ApplicationUser lead, String name, String key) throws Exception {
        ProjectCreationData projectCreationData = new ProjectCreationData.Builder().withName(name).withKey(key).withDescription("Foo").withLead(lead).withUrl("http://www.atlassian.com").build();
        ProjectService.CreateProjectValidationResult createProjectValidationResult = ((ProjectServiceBridge)this.projectServiceBridgeProxy.get()).validateCreateProject(lead, projectCreationData);
        return this.projectService.createProject(createProjectValidationResult);
    }

    public Project createScrumProject(ApplicationUser lead, String name, String key) throws Exception {
        return ((AgileProjectServiceBridge)this.agileProjectBridgeProxy.get()).createScrumProject(lead, name, key, name, lead.getName(), null, null, null);
    }

    public void deleteProject(Project project, ApplicationUser user) {
        ProjectService.DeleteProjectValidationResult deleteValidationResult = this.projectService.validateDeleteProject(user, project.getKey());
        if (deleteValidationResult.isValid()) {
            this.projectService.deleteProject(user, deleteValidationResult);
        }
    }
}

