/*
 * Decompiled with CFR 0.152.
 */
package it.com.radiantminds.plugins.jira;

import com.atlassian.rm.common.bridges.agile.license.AgileLicenseServiceBridge;
import com.atlassian.rm.common.bridges.agile.license.AgileLicenseServiceBridgeProxy;
import com.atlassian.rm.common.envtestutils.WiredIntegrationTestClassRule;
import com.atlassian.rm.common.envtestutils.WiredIntegrationTestMethodRule;
import com.atlassian.rm.common.envtestutils.WiredTestCase;
import com.atlassian.rm.common.envtestutils.WiredTestRuleFactory;
import com.atlassian.rm.common.envtestutils.annotations.AgileLicensing;
import com.atlassian.rm.common.envtestutils.annotations.AgileRequirements;
import com.radiantminds.roadmap.jira.common.components.agile.JiraAgileAccessor;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

public class JiraAgileTest
extends WiredTestCase {
    @Rule
    public final WiredIntegrationTestMethodRule wiredIntegrationTestRule = WiredTestRuleFactory.methodRule();
    @ClassRule
    public static final WiredIntegrationTestClassRule WIRED_INTEGRATION_TEST_CLASS_RULE = WiredTestRuleFactory.classRule();
    private final JiraAgileAccessor agileAccessor;
    private final AgileLicenseServiceBridgeProxy licenseServiceBridgeProxy;

    @Autowired
    public JiraAgileTest(JiraAgileAccessor agileAccessor, AgileLicenseServiceBridgeProxy licenseServiceBridgeProxy) {
        this.agileAccessor = agileAccessor;
        this.licenseServiceBridgeProxy = licenseServiceBridgeProxy;
    }

    @Test
    @AgileRequirements
    public void testAvailable() {
        Assert.assertTrue((boolean)this.agileAccessor.isAvailable());
    }

    @Test
    @AgileRequirements(installed=false)
    public void testUnavailable() {
        Assert.assertFalse((boolean)this.agileAccessor.isAvailable());
    }

    @Test
    @AgileRequirements(licensed=AgileLicensing.Unlicensed)
    public void testAvailableAndNotLicensed() throws Exception {
        ((AgileLicenseServiceBridge)this.licenseServiceBridgeProxy.get()).setCheckEnabled(true);
        Assert.assertFalse((boolean)this.agileAccessor.isUsable());
        ((AgileLicenseServiceBridge)this.licenseServiceBridgeProxy.get()).setCheckEnabled(false);
    }

    @Test
    @AgileRequirements(licensed=AgileLicensing.Licensed)
    public void testAvailableAndLicensedWithCheckDisabled() throws Exception {
        ((AgileLicenseServiceBridge)this.licenseServiceBridgeProxy.get()).setCheckEnabled(false);
        Assert.assertTrue((boolean)this.agileAccessor.isUsable());
    }
}

