/*
 * Decompiled with CFR 0.152.
 */
package it.com.radiantminds.plugins.jira;

import com.atlassian.jira.bc.issue.link.IssueLinkService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.rm.common.bridges.jira.issue.IssueServiceBridge;
import com.atlassian.rm.common.bridges.jira.issue.IssueServiceBridgeProxy;
import com.atlassian.rm.common.bridges.jira.issue.link.IssueLinkServiceBridge;
import com.atlassian.rm.common.bridges.jira.issue.link.IssueLinkServiceBridgeProxy;
import com.atlassian.rm.common.envtestutils.User;
import com.atlassian.rm.common.envtestutils.WiredIntegrationTestClassRule;
import com.atlassian.rm.common.envtestutils.WiredIntegrationTestMethodRule;
import com.atlassian.rm.common.envtestutils.WiredTestCase;
import com.atlassian.rm.common.envtestutils.WiredTestRuleFactory;
import com.atlassian.rm.common.envtestutils.annotations.AgileRequirements;
import com.atlassian.rm.common.envtestutils.annotations.Login;
import com.atlassian.rm.common.envtestutils.annotations.Projects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.extensions.workitems.IssueLinkRequest;
import com.radiantminds.roadmap.common.extensions.workitems.WorkItemExtension;
import it.com.radiantminds.plugins.jira.testdata.ScrumProject;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

public class WorkItemExtensionCreateInwardDepsTest
extends WiredTestCase {
    @Rule
    public final WiredIntegrationTestMethodRule wiredIntegrationTestRule = WiredTestRuleFactory.methodRule();
    @ClassRule
    public static final WiredIntegrationTestClassRule WIRED_INTEGRATION_TEST_CLASS_RULE = WiredTestRuleFactory.classRule();
    private final WorkItemExtension workItemExtension;
    private final JiraAuthenticationContext authenticationContext;
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final IssueServiceBridgeProxy issueServiceBridgeProxy;
    private final IssueLinkServiceBridgeProxy issueLinkServiceBridgeProxy;

    @Autowired
    public WorkItemExtensionCreateInwardDepsTest(WorkItemExtension workItemExtension, JiraAuthenticationContext authenticationContext, IssueLinkTypeManager issueLinkTypeManager, IssueServiceBridgeProxy issueServiceBridgeProxy, IssueLinkServiceBridgeProxy issueLinkServiceBridge) {
        this.workItemExtension = workItemExtension;
        this.authenticationContext = authenticationContext;
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.issueServiceBridgeProxy = issueServiceBridgeProxy;
        this.issueLinkServiceBridgeProxy = issueLinkServiceBridge;
    }

    @Test
    @Login(user=User.ADMIN)
    @AgileRequirements
    @Projects(value={ScrumProject.class})
    public void testCreateInwardDependency() throws Exception {
        Project scrumProject = this.wiredIntegrationTestRule.getProject(ScrumProject.class);
        final String projectKey = scrumProject.getKey();
        IssueLinkRequest request = new IssueLinkRequest(){

            public List<String> getInwardIds() {
                return Lists.newArrayList((Object[])new String[]{projectKey + "-2"});
            }

            public List<String> getOutwardIds() {
                return Lists.newArrayList();
            }

            public Set<String> getIssueKeys() {
                return Sets.newHashSet((Object[])new String[]{projectKey + "-3"});
            }

            public String getLinkTypeId() {
                return "10000";
            }
        };
        this.workItemExtension.createIssueLinksForDependencies(request);
        ApplicationUser authenticatedUser = this.authenticationContext.getUser();
        MutableIssue targetIssue = ((IssueServiceBridge)this.issueServiceBridgeProxy.get()).getIssue(authenticatedUser, projectKey + "-3").getIssue();
        MutableIssue inwardIssue = ((IssueServiceBridge)this.issueServiceBridgeProxy.get()).getIssue(authenticatedUser, projectKey + "-2").getIssue();
        IssueLinkService.IssueLinkResult linkResult = ((IssueLinkServiceBridge)this.issueLinkServiceBridgeProxy.get()).getIssueLinks(authenticatedUser, (Issue)targetIssue);
        IssueLinkType dependencyLinkType = this.issueLinkTypeManager.getIssueLinkType(Long.valueOf(10000L));
        Assert.assertTrue((boolean)linkResult.getLinkCollection().getLinkTypes().contains(dependencyLinkType));
        Assert.assertNotNull((Object)linkResult);
        Assert.assertTrue((boolean)linkResult.isValid());
        Assert.assertEquals((Object)true, (Object)linkResult.getLinkCollection().getAllIssues().contains(inwardIssue));
        Assert.assertTrue((linkResult.getLinkCollection().getInwardIssues(dependencyLinkType.getName()).size() == 1 ? 1 : 0) != 0);
    }
}

