/*
 * Decompiled with CFR 0.152.
 */
package it.com.radiantminds.plugins.jira.lucene;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.issue.worklog.WorklogService;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.rm.common.bridges.agile.customfields.AgileCustomFieldsServiceBridgeProxy;
import com.atlassian.rm.common.bridges.jira.issue.IssueServiceBridgeProxy;
import com.atlassian.rm.common.envtestutils.User;
import com.atlassian.rm.common.envtestutils.WiredIntegrationTestClassRule;
import com.atlassian.rm.common.envtestutils.WiredIntegrationTestMethodRule;
import com.atlassian.rm.common.envtestutils.WiredTestRuleFactory;
import com.atlassian.rm.common.envtestutils.annotations.Login;
import com.atlassian.rm.common.envtestutils.annotations.Projects;
import com.atlassian.rm.common.envtestutils.tools.IssueType;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.plans.TrackerType;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItemExtensionLinkData;
import com.radiantminds.roadmap.common.extensions.workitems.ProgressConfiguration;
import com.radiantminds.roadmap.common.extensions.workitems.WorkItemExtension;
import com.radiantminds.roadmap.common.stats.MonitoredCallResult;
import com.radiantminds.roadmap.jira.common.components.utils.customfields.CustomFieldsService;
import it.com.radiantminds.plugins.jira.lucene.BaseLuceneExtensionLinkDataTest;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;

public class SimpleLuceneExtensionLinkDataTest
extends BaseLuceneExtensionLinkDataTest {
    @Rule
    public final WiredIntegrationTestMethodRule wiredIntegrationTestRule = WiredTestRuleFactory.methodRule();
    @ClassRule
    public static final WiredIntegrationTestClassRule WIRED_INTEGRATION_TEST_CLASS_RULE = WiredTestRuleFactory.classRule();

    @Autowired
    public SimpleLuceneExtensionLinkDataTest(IssueServiceBridgeProxy issueServiceBridgeVersionProxy, AgileCustomFieldsServiceBridgeProxy agileCustomFieldsServiceBridgeProxy, CustomFieldsService customFields, IssueTypeManager issueTypeManager, JiraAuthenticationContext authenticationContext, IssueService issueService, IssueIndexManager issueIndexManager, WorklogService worklogService, WorkItemExtension workItemExtension) {
        super(issueServiceBridgeVersionProxy, agileCustomFieldsServiceBridgeProxy, customFields, issueTypeManager, authenticationContext, issueService, issueIndexManager, worklogService, workItemExtension);
    }

    @Test
    @Login(user=User.ADMIN)
    @Projects(value={BaseLuceneExtensionLinkDataTest.LuceneExtensionTestProjectDefinition.class})
    public void testSimpleGet() throws Exception {
        ApplicationUser user = this.authenticationContext.getUser();
        ProgressConfiguration progressConfiguration = (ProgressConfiguration)Mockito.mock(ProgressConfiguration.class);
        Mockito.when((Object)progressConfiguration.getTrackerType()).thenReturn((Object)TrackerType.TimeBased);
        Project project = this.wiredIntegrationTestRule.getProject(BaseLuceneExtensionLinkDataTest.LuceneExtensionTestProjectDefinition.class);
        HashSet issueKeys = Sets.newHashSet();
        Issue issue = this.wiredIntegrationTestRule.getWiredTestUtils().getIssueUtils().createIssue(project, user, IssueType.TASK, 480L);
        this.createWorklog(issue, "4h");
        issueKeys.add(issue.getKey());
        MonitoredCallResult monitoredCallResult = this.workItemExtension.getExtensionLinkData(progressConfiguration, (Set)issueKeys);
        WorkItemExtensionLinkData data = (WorkItemExtensionLinkData)monitoredCallResult.getResult();
        Assert.assertEquals((double)data.getProgress(issue.getKey()).getDonePercentage(), (double)0.5, (double)1.0E-5);
        Assert.assertEquals((Object)false, (Object)data.getStatusData(issue.getKey()).isDone());
    }
}

