/*
 * Decompiled with CFR 0.152.
 */
package it.com.radiantminds.plugins.jira.testdata;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.rm.common.envtestutils.DisposableProjectDefinition;
import com.atlassian.rm.common.envtestutils.WiredTestUtils;
import it.com.radiantminds.plugins.jira.testutils.PermissionUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ReadOnlyToNonAdminProject
implements DisposableProjectDefinition {
    private final PermissionUtils permissionUtils;
    private Scheme restrictedPermissionsScheme;

    @Autowired
    public ReadOnlyToNonAdminProject(PermissionUtils permissionUtils) throws Exception {
        this.permissionUtils = permissionUtils;
    }

    public void cleanup(WiredTestUtils wiredTestUtils, Project project) throws Exception {
        this.permissionUtils.removeSchemesFromProject(project);
        this.permissionUtils.deletePermissionsScheme(this.restrictedPermissionsScheme);
    }

    public Project instantiate(WiredTestUtils utils) throws Exception {
        Project project = utils.getProjectUtils().createStandardProject(utils.getLoginManager().getLoggedInUser(), "Readonly to Non-Admin", "RTNA");
        utils.getVersionUtils().createVersionInProject("X", project);
        this.restrictedPermissionsScheme = this.permissionUtils.createRestrictedPermissionsScheme();
        this.permissionUtils.addSchemeToProject(project, this.restrictedPermissionsScheme);
        return project;
    }
}

