/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.agile.sprints;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintManager;
import com.atlassian.greenhopper.service.sprint.SprintUtils;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.fields.SelectableField;
import com.atlassian.jira.issue.search.IssueCollectBuilder;
import com.atlassian.jira.issue.search.SearchRequestManager;
import com.atlassian.jira.issue.search.SelectableFieldRegistry;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.query.Query;
import com.atlassian.rm.common.bridges.agile.AgileNotAvailableException;
import com.atlassian.rm.common.bridges.agile.AgileServiceOutcomeException;
import com.atlassian.rm.common.bridges.agile.customfields.AgileCustomFieldNotAvailableException;
import com.atlassian.rm.common.bridges.agile.customfields.AgileCustomFieldServiceBridge;
import com.atlassian.rm.common.bridges.agile.customfields.AgileCustomFieldsServiceBridgeProxy;
import com.atlassian.rm.common.bridges.agile.service.BundleServiceServiceOutcomeHandler;
import com.atlassian.rm.common.bridges.agile.sprints.AgileSprint;
import com.atlassian.rm.common.bridges.agile.sprints.AgileSprintManagerBridge;
import com.atlassian.rm.common.bridges.agile.sprints.BaseAgileSprintManagerBridge;
import com.atlassian.rm.common.bridges.agile.sprints.SprintsTransformer;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.api.plugins.access.BundleServiceAccessorProvider;
import com.atlassian.rm.common.bridges.api.plugins.access.ServiceCallback;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.agile.sprints.AgileSprintManagerBridgeCloud")
@SupportedVersions(all=true)
public class AgileSprintManagerBridgeCloud
extends BaseAgileSprintManagerBridge
implements AgileSprintManagerBridge {
    private final SearchService searchService;
    private final SelectableFieldRegistry selectableFieldRegistry;
    private final AgileCustomFieldServiceBridge agileCustomFieldServiceBridge;
    private static final Log LOGGER = Log.with(AgileSprintManagerBridgeCloud.class);
    private static String SPRINT_MANAGER_CLASS = "com.atlassian.greenhopper.service.sprint.SprintManager";

    @Autowired
    public AgileSprintManagerBridgeCloud(BundleServiceAccessorProvider bundleServiceAccessorProvider, SearchRequestManager searchRequestManager, AgileCustomFieldsServiceBridgeProxy agileCustomFieldServiceBridgeProxy, SearchService searchService, SelectableFieldRegistry selectableFieldRegistry, AgileCustomFieldServiceBridge agileCustomFieldServiceBridge) {
        super(bundleServiceAccessorProvider, searchRequestManager, agileCustomFieldServiceBridgeProxy, new BundleServiceServiceOutcomeHandler(bundleServiceAccessorProvider, SPRINT_MANAGER_CLASS), bundleServiceAccessorProvider.createServiceAccessor(SPRINT_MANAGER_CLASS));
        this.searchService = searchService;
        this.selectableFieldRegistry = selectableFieldRegistry;
        this.agileCustomFieldServiceBridge = agileCustomFieldServiceBridge;
    }

    @Override
    protected Collection<Sprint> getSprints(final Collection<Long> ids) throws Exception {
        return this.sprintManagerServiceAccessor.perform(new ServiceCallback<SprintManager, Collection<Sprint>>(){

            @Override
            public Collection<Sprint> perform(SprintManager sprintManager) throws Exception {
                return sprintManager.getSprints(ids);
            }
        });
    }

    @Override
    public List<AgileSprint> tryFindSprintsWithoutPermissionCheck(ApplicationUser user, final long boardId, final Set<AgileSprint.State> states) throws AgileServiceOutcomeException, AgileNotAvailableException, AgileCustomFieldNotAvailableException {
        Collection<Sprint> sprints;
        LOGGER.debug("sprint query for board: %d", boardId);
        Optional<?> rapidView = this.getRapidViewWithoutPermissionCheck(boardId);
        if (!rapidView.isPresent()) {
            LOGGER.debug("no view found for board: %d", boardId);
            return Lists.newArrayList();
        }
        if (!((RapidView)rapidView.get()).isSprintSupportEnabled()) {
            LOGGER.debug("sprints not supported", new Object[0]);
            return Lists.newArrayList();
        }
        Collection<Sprint> additionalSprints = this.getAdditionalSprintsForRapidView(user, rapidView.get(), states);
        try {
            sprints = this.sprintManagerServiceAccessor.perform(new ServiceCallback<SprintManager, Collection<Sprint>>(){

                @Override
                public Collection<Sprint> perform(SprintManager sprintManager) throws Exception {
                    return sprintManager.getSprintsForView(Long.valueOf(boardId), EnumSet.copyOf(SprintsTransformer.transformSprintStates(states)));
                }
            });
        }
        catch (Exception e) {
            throw new AgileServiceOutcomeException("Failed to access sprint manager.", e);
        }
        HashSet combinedSprints = Sets.newHashSet(sprints);
        combinedSprints.addAll(additionalSprints);
        ArrayList sortedSprints = Lists.newArrayList((Iterable)combinedSprints);
        Collections.sort(sortedSprints, SprintUtils.SPRINT_NATURAL_COMPARATOR);
        return SprintsTransformer.transformSprints(sortedSprints);
    }

    @Override
    protected List<Sprint> getSprintsWithQuery(ApplicationUser user, Query jql) throws AgileNotAvailableException, AgileCustomFieldNotAvailableException, AgileServiceOutcomeException {
        try {
            String sprintFieldId = this.agileCustomFieldServiceBridge.getCustomFields().getSprintsField().getId();
            SelectableField sprintSelectableField = this.selectableFieldRegistry.getSelectableField(sprintFieldId);
            List sprintIdsOfIssues = ((IssueCollectBuilder.Mappable)this.searchService.collect().select(new SelectableField[]{sprintSelectableField}).whereAndOrderBy(jql).page(PagerFilter.getUnlimitedFilter()).overrideSecurity(user)).map(issueRowResult -> (Set)issueRowResult.getValue(sprintSelectableField)).execute();
            Set<Long> sprintIds = sprintIdsOfIssues.stream().flatMap(sprintIdsOfIssue -> sprintIdsOfIssue.stream()).filter(Objects::nonNull).collect(Collectors.toSet());
            List<Sprint> sortedSprints = this.getSprints(sprintIds).stream().sorted((Comparator<Sprint>)SprintUtils.SPRINT_BYDATE_COMPARATOR).collect(Collectors.toList());
            return sortedSprints;
        }
        catch (Exception e) {
            throw new AgileServiceOutcomeException(e.getMessage());
        }
    }
}

