/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.agile.sprints;

import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.rm.common.bridges.agile.sprints.AgileSprint;
import com.atlassian.rm.common.bridges.agile.sprints.DefaultAgileSprint;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class SprintsTransformer {
    public static Set transformSprintStates(Set<AgileSprint.State> states) {
        return Sets.newHashSet((Iterable)Iterables.transform(states, (Function)new Function<AgileSprint.State, Sprint.State>(){

            public Sprint.State apply(AgileSprint.State input) {
                return (Sprint.State)SprintsTransformer.transformSprintState(input);
            }
        }));
    }

    public static List<AgileSprint> transformSprints(Collection sprints) {
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)sprints, (Function)new Function<Sprint, AgileSprint>(){

            public AgileSprint apply(@Nullable Sprint sprint) {
                return SprintsTransformer.sprintToAgileSprint(sprint);
            }
        }));
    }

    public static AgileSprint sprintToAgileSprint(@Nullable Object sprintAsObject) {
        if (sprintAsObject == null) {
            return null;
        }
        Sprint sprint = (Sprint)sprintAsObject;
        return new DefaultAgileSprint.Builder().id(sprint.getId()).title(sprint.getName()).agileBoardId(sprint.getRapidViewId()).state(SprintsTransformer.transformSprintState(sprint.getState())).sequence(sprint.getSequence()).startDate(SprintsTransformer.dateTimeToLong(sprint.getStartDate())).endDate(SprintsTransformer.dateTimeToLong(sprint.getEndDate())).completeDate(SprintsTransformer.dateTimeToLong(sprint.getCompleteDate())).build();
    }

    public static Object agileSprintToSprint(AgileSprint agileSprint) {
        Sprint.State state = (Sprint.State)SprintsTransformer.transformSprintState(agileSprint.getState());
        return Sprint.builder().id(Long.valueOf(agileSprint.getId())).name(agileSprint.getTitle()).rapidViewId((Long)agileSprint.getAgileBoardId().orNull()).state(state).sequence((Long)agileSprint.getSequence().orNull()).startDate((Long)agileSprint.getStartDate().orNull()).endDate((Long)agileSprint.getEndDate().orNull()).completeDate((Long)agileSprint.getCompleteDate().orNull()).build();
    }

    private static Long dateTimeToLong(@Nullable DateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return dateTime.getMillis();
    }

    public static AgileSprint.State transformSprintState(Object stateAsObject) {
        return AgileSprint.State.valueOf(stateAsObject.toString());
    }

    private static Object transformSprintState(AgileSprint.State agileState) {
        return Sprint.State.valueOf((String)agileState.toString());
    }
}

