/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.api;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.api.VersionRange;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;

public class Version
implements Comparable<Version> {
    private static final Log LOGGER = Log.with(Version.class);
    private final org.osgi.framework.Version version;
    private final Set<String> flags;

    public Version(String versionString) {
        this(versionString, Collections.emptySet());
    }

    public Version(String versionString, Set<String> flags) {
        this.version = Version.parse(versionString);
        this.flags = Collections.unmodifiableSet(flags);
    }

    public Version(Version version, Set<String> flags) {
        this.version = version.version;
        this.flags = Collections.unmodifiableSet(flags);
    }

    @Override
    public int compareTo(Version other) {
        return this.version.compareTo(other.version);
    }

    public boolean isInRange(Optional<String> minInclusive, Optional<String> maxExclusive) {
        Version minInclusiveVersion = minInclusive.isPresent() ? new Version((String)minInclusive.get()) : null;
        Version maxExclusiveVersion = maxExclusive.isPresent() ? new Version((String)maxExclusive.get()) : null;
        return this.isInRange(minInclusiveVersion, maxExclusiveVersion);
    }

    public boolean isInRange(VersionRange versionRange) {
        return this.isInRange(versionRange.getMinInclusive(), versionRange.getMaxExclusive());
    }

    public boolean isInRange(Version minInclusive) {
        return minInclusive.compareTo(this) <= 0;
    }

    public boolean isSupported(SupportedVersions supportedVersions) {
        if (!this.flags.containsAll(Arrays.asList(supportedVersions.requiredFlags()))) {
            LOGGER.debug("not all required flags available: %s", Arrays.toString(supportedVersions.requiredFlags()));
            return false;
        }
        if (!Sets.intersection(this.flags, (Set)Sets.newHashSet((Object[])supportedVersions.prohibitedFlags())).isEmpty()) {
            LOGGER.debug("a prohibited flag is contained: %s", Arrays.toString(supportedVersions.prohibitedFlags()));
            return false;
        }
        if (supportedVersions.all()) {
            return true;
        }
        return this.isInRange((Optional<String>)Optional.of((Object)supportedVersions.minInclusive()), (Optional<String>)Optional.of((Object)supportedVersions.maxExclusive()));
    }

    public boolean isFlagSet(String flag) {
        return this.flags.contains(flag);
    }

    public String toString() {
        return this.version.toString();
    }

    private boolean isInRange(Version minInclusive, Version maxExclusive) {
        boolean minSatisfied;
        boolean bl = minInclusive != null ? minInclusive.compareTo(this) <= 0 : (minSatisfied = true);
        boolean maxSatisfied = maxExclusive != null ? this.compareTo(maxExclusive) < 0 : true;
        return minSatisfied && maxSatisfied;
    }

    private static org.osgi.framework.Version parse(String versionString) {
        String noHyphenIdentifierString = Version.stripIdentifiersAfterHyphen(versionString);
        String noNonNumericCharString = Version.removeNonNumericCharacters(noHyphenIdentifierString);
        return new org.osgi.framework.Version(noNonNumericCharString);
    }

    private static String stripIdentifiersAfterHyphen(String versionString) {
        int hyphenIndex = versionString.indexOf(45);
        if (hyphenIndex == -1) {
            return versionString;
        }
        return versionString.substring(0, hyphenIndex);
    }

    private static String removeNonNumericCharacters(String versionString) {
        return versionString.replaceAll("[^\\d.]", "");
    }
}

