/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira;

import com.atlassian.rm.common.bridges.api.Version;
import com.atlassian.rm.common.bridges.jira.SimpleJiraVersionAccessor;
import com.atlassian.rm.common.bridges.jira.properties.JiraPropertiesBridge;
import com.atlassian.rm.common.bridges.jira.properties.JiraPropertiesBridgeProxy;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.JiraVersionAccessor")
public class JiraVersionAccessor {
    private static final Version JIRA_CLOUD_FORK_VERSION = new Version("1000.0.0");
    public static final String VERTIGO_FLAG = "vertigo";
    private final SimpleJiraVersionAccessor jiraVersionAccessor;
    private final JiraPropertiesBridgeProxy jiraProperties;

    @Autowired
    public JiraVersionAccessor(SimpleJiraVersionAccessor jiraVersionAccessor, JiraPropertiesBridgeProxy jiraProperties) {
        this.jiraVersionAccessor = jiraVersionAccessor;
        this.jiraProperties = jiraProperties;
    }

    public Version getVersion() {
        return new Version(this.jiraVersionAccessor.getVersion(), this.getFlags());
    }

    private Set<String> getFlags() {
        if (((JiraPropertiesBridge)this.jiraProperties.get()).isInVertigoMode()) {
            return Sets.newHashSet((Object[])new String[]{VERTIGO_FLAG});
        }
        return Collections.emptySet();
    }

    public boolean isPostForkCloudVersion() {
        return this.isInVersionRange(JIRA_CLOUD_FORK_VERSION);
    }

    public boolean isInVersionRange(Version version) {
        Version jira = this.getVersion();
        return jira != null && jira.isInRange(version);
    }
}

