/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.cache;

import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.cache.CacheFactoryBridge;
import com.atlassian.rm.common.bridges.jira.cache.LoadFunction;
import com.atlassian.rm.common.bridges.jira.cache.RequestCacheBridge;
import com.atlassian.vcache.RequestCache;
import com.atlassian.vcache.VCacheFactory;
import com.google.common.base.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.cache.CacheFactoryBridgeCloud")
@SupportedVersions(all=true)
class CacheFactoryBridgeCloud
implements CacheFactoryBridge {
    private static final String KEY = "key";
    private final VCacheFactory factory;

    @Autowired
    CacheFactoryBridgeCloud(VCacheFactory factory) {
        this.factory = factory;
    }

    @Override
    public void signalNewRequest() {
    }

    @Override
    public <T> RequestCacheBridge<T> createRequestCache(String id, int expireSecondsAfterAccess) {
        return this.createRequestCache(id);
    }

    @Override
    public <T> RequestCacheBridge<T> createRequestCache(String id) {
        final RequestCache vCache = this.factory.getRequestCache(id);
        return new RequestCacheBridge<T>(){

            @Override
            public Optional<T> get() {
                return Optional.fromNullable(vCache.get((Object)CacheFactoryBridgeCloud.KEY).orElse(null));
            }

            @Override
            public T getOrLoad(LoadFunction<T> loader) throws Exception {
                Object cached = vCache.get((Object)CacheFactoryBridgeCloud.KEY).orElse(null);
                if (cached != null) {
                    return cached;
                }
                Object loaded = loader.load();
                this.store(loaded);
                return loaded;
            }

            @Override
            public void store(T value) {
                vCache.put((Object)CacheFactoryBridgeCloud.KEY, value);
            }
        };
    }
}

