/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.group;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.group.GroupManagerBridge;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.group.GroupManagerBridgeCloud")
@SupportedVersions(all=true)
public class GroupManagerBridgeCloud
implements GroupManagerBridge {
    private static final Log LOGGER = Log.with(GroupManagerBridgeCloud.class);
    private final GroupManager groupManager;

    @Autowired
    public GroupManagerBridgeCloud(GroupManager groupManager) {
        this.groupManager = groupManager;
    }

    @Override
    public Collection<Group> getGroupsForUser(ApplicationUser user) {
        return this.groupManager.getGroupsForUser(user);
    }

    @Override
    public List<String> listGroups(String query, Collection<String> excludes, int maxResults) {
        Preconditions.checkNotNull((Object)query);
        Preconditions.checkNotNull(excludes);
        LOGGER.debug("list groups for query: %s, excluding %s (max %d)", query, Joiner.on((String)",").join(excludes, (Object)maxResults, new Object[0]));
        ArrayList matchingGroupNames = Lists.newArrayList();
        for (Group group : this.groupManager.getAllGroups()) {
            if (matchingGroupNames.size() == maxResults) break;
            if (!group.getName().toLowerCase().contains(query.toLowerCase()) || excludes.contains(group.getName())) continue;
            matchingGroupNames.add(group.getName());
        }
        LOGGER.debug("found groups: %s", Joiner.on((String)",").join((Iterable)matchingGroupNames));
        return matchingGroupNames;
    }

    @Override
    public Set<String> filterNonExistingGroupNames(Set<String> names) {
        Preconditions.checkNotNull(names);
        LOGGER.debug("filter non existing group names: %s", Joiner.on((String)",").join(names));
        Sets.SetView result = Sets.difference(names, this.getExistingGroupNames());
        LOGGER.debug("found %d non existing group names: {}", result.size(), Joiner.on((String)",").join((Iterable)result));
        return result;
    }

    private Set<String> getExistingGroupNames() {
        Collection groups = this.groupManager.getAllGroups();
        HashSet names = Sets.newHashSetWithExpectedSize((int)groups.size());
        for (Group group : groups) {
            names.add(group.getName());
        }
        return names;
    }
}

