/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.issue.search;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.jql.context.QueryContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.Query;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.search.SearchServiceBridge;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.issue.search.SearchServiceBridgeCloud")
@SupportedVersions(all=true)
public class SearchServiceBridgeCloud
implements SearchServiceBridge {
    private final SearchService searchService;

    @Autowired
    public SearchServiceBridgeCloud(SearchService searchService) {
        this.searchService = searchService;
    }

    @Override
    public SearchResults search(ApplicationUser searcher, Query query, PagerFilter pager) throws SearchException {
        return this.searchService.search(searcher, query, pager);
    }

    @Override
    public SearchService.ParseResult parseQuery(ApplicationUser searcher, String query) {
        return this.searchService.parseQuery(searcher, query);
    }

    @Override
    public Set<Long> getProjectFromQuery(ApplicationUser applicationUser, Query query) {
        return this.getProjectFromQuery((Optional<ApplicationUser>)Optional.of((Object)applicationUser), query);
    }

    @Override
    public Set<Long> getProjectFromQueryWithoutPermissions(Query query) {
        return this.getProjectFromQuery((Optional<ApplicationUser>)Optional.absent(), query);
    }

    private Set<Long> getProjectFromQuery(Optional<ApplicationUser> user, Query query) {
        QueryContext queryContext = this.searchService.getQueryContext((ApplicationUser)user.orNull(), query);
        HashSet projectIds = Sets.newHashSet();
        for (QueryContext.ProjectIssueTypeContexts contexts : queryContext.getProjectIssueTypeContexts()) {
            projectIds.addAll(contexts.getProjectIdInList());
        }
        return projectIds;
    }
}

