/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.lifecycle;

import cloud.atlassian.provisioning.TenantedEventRegistrar;
import cloud.atlassian.provisioning.TenantedPlatformInitialisedEvent;
import cloud.atlassian.provisioning.TenantedPlatformInitialisedListener;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.api.RequiredFeatures;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.launch.PluginKeyProvider;
import com.atlassian.rm.common.bridges.jira.lifecycle.PluginProvisioningTaskServiceBridge;
import com.atlassian.rm.common.bridges.jira.lifecycle.ProvisioningTask;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.lifecycle.PluginProvisioningTaskServiceBridgeVertigo")
@SupportedVersions(all=true)
@RequiredFeatures(value={"com.atlassian.rm.portfolio.vertigo.Provisioning"})
class PluginProvisioningTaskServiceBridgeVertigo
implements PluginProvisioningTaskServiceBridge,
TenantedPlatformInitialisedListener {
    private static final Log LOGGER = Log.with(PluginProvisioningTaskServiceBridgeVertigo.class);
    private static final int WEIGHT = 1;
    private final PluginKeyProvider pluginKeyProvider;
    private final TenantedEventRegistrar tenantedEventRegistrar;
    private List<ProvisioningTask> tasks = Collections.emptyList();

    @Autowired
    PluginProvisioningTaskServiceBridgeVertigo(PluginKeyProvider pluginKeyProvider, TenantedEventRegistrar tenantedEventRegistrar) {
        this.pluginKeyProvider = pluginKeyProvider;
        this.tenantedEventRegistrar = tenantedEventRegistrar;
    }

    @PostConstruct
    public void postConstruct() {
        LOGGER.info("register platform listener", new Object[0]);
        this.tenantedEventRegistrar.registerPlatformInitialisedListener((TenantedPlatformInitialisedListener)this, 1);
    }

    @PreDestroy
    public void preDestroy() {
        LOGGER.info("unregister platform listener", new Object[0]);
        this.tenantedEventRegistrar.unregisterPlatformInitialisedListener((TenantedPlatformInitialisedListener)this);
    }

    public Map<String, String> platformInitialised(TenantedPlatformInitialisedEvent event) {
        LOGGER.info("Got 'platform initialized' event - time to get started!", new Object[0]);
        LOGGER.info("Launching %s", this.pluginKeyProvider.getDisplayName());
        this.tasks.stream().forEach(task -> {
            try {
                LOGGER.info("Executing launch task '%s'...", task.getDisplayName());
                task.execute();
                LOGGER.info("Launch task '%s' finished.", task.getDisplayName());
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected error during launch of task '$s'.", task.getDisplayName());
                LOGGER.exception(ex, Log.LogLevel.ERROR);
            }
        });
        LOGGER.info("%s launched successfully.", this.pluginKeyProvider.getDisplayName());
        return Collections.emptyMap();
    }

    @Override
    public void tryTriggerProvisioningTasks() {
        LOGGER.debug("ignore external trigger", new Object[0]);
    }

    @Override
    public void setProvisioningTasks(List<ProvisioningTask> provisioningTasks) {
        this.tasks = provisioningTasks;
    }
}

