/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.project;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.project.ProjectCreationData;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.project.ProjectCreationData;
import com.atlassian.rm.common.bridges.jira.project.ProjectServiceBridge;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.project.ProjectServiceBridgeCloud")
@SupportedVersions(all=true)
public class ProjectServiceBridgeCloud
implements ProjectServiceBridge {
    private final ProjectService projectService;

    @Autowired
    public ProjectServiceBridgeCloud(ProjectService projectService) {
        this.projectService = projectService;
    }

    @Override
    public ProjectService.CreateProjectValidationResult validateCreateProject(ApplicationUser user, ProjectCreationData projectCreationData) {
        return this.projectService.validateCreateProject(user, new ProjectCreationData.Builder().withName(projectCreationData.getName()).withKey(projectCreationData.getKey()).withDescription(projectCreationData.getDescription()).withLead(projectCreationData.getLead()).withUrl(projectCreationData.getUrl()).withAssigneeType(projectCreationData.getAssigneeType()).withAvatarId(projectCreationData.getAvatarId()).withProjectTemplateKey(projectCreationData.getProjectTemplateKey().getKey()).build());
    }

    @Override
    public ProjectService.GetProjectResult getProjectById(ApplicationUser user, long projectId) {
        return this.projectService.getProjectById(user, Long.valueOf(projectId));
    }

    @Override
    public Set<Long> getBrowsableProjectIds(ApplicationUser user) {
        ServiceOutcome allProjects = this.projectService.getAllProjects(user);
        return Sets.newHashSet((Iterable)Iterables.transform((Iterable)((Iterable)allProjects.get()), (Function)new Function<Project, Long>(){

            public Long apply(Project project) {
                return project.getId();
            }
        }));
    }
}

