/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.analysis;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.analysis.EligibleWorkTimeLineCalculator;
import com.atlassian.rm.jpo.scheduling.roadmap.analysis.IEligibleWorkTimeLine;
import com.atlassian.rm.jpo.scheduling.roadmap.analysis.IEligibleWorkTimeLineCalculator;
import com.atlassian.rm.jpo.scheduling.roadmap.analysis.ISlotBottleneckAnalysis;
import com.atlassian.rm.jpo.scheduling.roadmap.analysis.ISlotBottleneckResult;
import com.atlassian.rm.jpo.scheduling.roadmap.analysis.SlotBottleneckResult;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.problem.IRoadmapProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IRoadmapSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SlotBottleneckAnalysis
implements ISlotBottleneckAnalysis {
    private static final Log LOGGER = Log.with(SlotBottleneckAnalysis.class);
    private final IEligibleWorkTimeLineCalculator eligibleWorkTimeLineCalculator;

    public SlotBottleneckAnalysis() {
        this(new EligibleWorkTimeLineCalculator());
    }

    SlotBottleneckAnalysis(EligibleWorkTimeLineCalculator eligibleWorkTimeLineCalculator) {
        this.eligibleWorkTimeLineCalculator = eligibleWorkTimeLineCalculator;
    }

    @Override
    public ISlotBottleneckResult calculateSlotBottlenecks(IRoadmapProblem problem, IRoadmapSchedule schedule) {
        LOGGER.info("start bottleneck analysis", new Object[0]);
        IEligibleWorkTimeLine eligibleWorkTimeLine = this.eligibleWorkTimeLineCalculator.calculateEligibleWorkTimeLine(problem, schedule);
        Map<IWorkSlot, PositivePrimitivesMap<IResourceType>> slotToBottleneckValues = SlotBottleneckAnalysis.createSlotBottlenecks(eligibleWorkTimeLine, problem.getResourceGroups());
        SlotBottleneckResult result = new SlotBottleneckResult(slotToBottleneckValues);
        LOGGER.info("finished bottleneck analysis", new Object[0]);
        return result;
    }

    private static Map<IWorkSlot, PositivePrimitivesMap<IResourceType>> createSlotBottlenecks(IEligibleWorkTimeLine eligibleWorkTimeLine, Set<IResourceGroup> groups) {
        HashMap slotBottlenecks = Maps.newHashMapWithExpectedSize((int)groups.size());
        for (IResourceGroup group : groups) {
            Map<IWorkSlot, PositivePrimitivesMap<IResourceType>> groupBottlenecks = SlotBottleneckAnalysis.calculateBottlenecksForGroup(group, eligibleWorkTimeLine);
            slotBottlenecks.putAll(groupBottlenecks);
        }
        return slotBottlenecks;
    }

    private static Map<IWorkSlot, PositivePrimitivesMap<IResourceType>> calculateBottlenecksForGroup(IResourceGroup group, IEligibleWorkTimeLine eligibleWorkTimeLine) {
        List<IWorkSlot> slots = group.getWorkSlotsBetween(0, eligibleWorkTimeLine.getEndTime());
        HashMap slotsBottlenecks = Maps.newHashMapWithExpectedSize((int)slots.size());
        for (IWorkSlot slot : slots) {
            PositivePrimitivesMap<IResourceType> bottleneckValues = eligibleWorkTimeLine.getEligibleWorkForTimeAndResourceGroup(slot.getStart(), group);
            slotsBottlenecks.put(slot, bottleneckValues);
        }
        return slotsBottlenecks;
    }
}

