/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.ICausalDependencyState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.ReleaseDependencyDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.dep.IDependencyDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
class CausalDependencyState
implements ICausalDependencyState {
    private static final Log LOGGER = Log.with(CausalDependencyState.class);
    private final Map<String, Set<String>> directSuccessorMap;
    private final boolean syncDependeeStartEnabled;
    private final Map<String, Integer> releaseTimes;
    private final Map<String, Integer> temporaryReleaseTimes;
    private final Map<String, Set<String>> openPredecessorMap;
    private final IDependencyDefinition dependencyDefinition;
    private final Map<String, IProcessingItem> itemMap;

    CausalDependencyState(Map<String, Set<String>> directSuccessors, Map<String, Integer> releaseTimes, Map<String, Set<String>> openPredecessorMap, Map<String, Integer> temporaryReleaseTimes, IDependencyDefinition dependencyDefinition, Map<String, IProcessingItem> itemMap, boolean syncDependeeStartEnabled) {
        this.releaseTimes = releaseTimes;
        this.openPredecessorMap = openPredecessorMap;
        this.directSuccessorMap = Collections.unmodifiableMap(directSuccessors);
        this.temporaryReleaseTimes = temporaryReleaseTimes;
        this.dependencyDefinition = dependencyDefinition;
        this.itemMap = itemMap;
        this.syncDependeeStartEnabled = syncDependeeStartEnabled;
    }

    @Override
    public void setFinishedItemWithSchedule(String itemId, IIntegerInterval interval) {
        this.updateState(itemId, this.syncDependeeStartEnabled ? interval.getStart() : interval.getEnd() + 1);
    }

    @Override
    public void setUnschedulableItem(String depItemId) {
        this.updateState(depItemId, 0);
    }

    @Override
    public Optional<Integer> getCausalReleaseTime(String itemId) {
        Integer releaseTime = this.releaseTimes.get(itemId);
        LogUtil.debug(LOGGER, "causal release time of item %s: %s", itemId, releaseTime);
        return Optional.fromNullable((Object)releaseTime);
    }

    @Override
    public void updateCausalReleaseTime(String itemId, int releaseTime) {
        this.releaseTimes.put(itemId, releaseTime);
    }

    @Override
    public Set<String> getOpenPredecessors(String id) {
        return this.openPredecessorMap.get(id);
    }

    @Override
    public Set<String> getTransitiveDependees(String itemId) {
        Set<IProcessingItem> dependees = this.dependencyDefinition.getTransitiveDependents(this.itemMap.get(itemId));
        if (dependees == null) {
            return Sets.newHashSet();
        }
        return RmIdentifiableUtils.getIds(dependees);
    }

    private void updateState(String id, int successorRelease) {
        LogUtil.debug(LOGGER, "set item with id %s finished with end time: %s", id, successorRelease);
        this.releaseTimes.remove(id);
        this.openPredecessorMap.remove(id);
        for (String successor : this.directSuccessorMap.get(id)) {
            Integer releaseTime = this.temporaryReleaseTimes.get(successor);
            int newReleaseTime = RmUtils.getOptionalMax(successorRelease, (Optional<Integer>)Optional.fromNullable((Object)releaseTime));
            this.temporaryReleaseTimes.put(successor, newReleaseTime);
        }
        this.removeFromOpenPredecessors(id);
    }

    private void removeFromOpenPredecessors(String id) {
        for (Map.Entry<String, Set<String>> predecessorEntry : this.openPredecessorMap.entrySet()) {
            Set<String> predecessors = predecessorEntry.getValue();
            predecessors.remove(id);
            String sucessorId = predecessorEntry.getKey();
            if (!predecessors.isEmpty() || this.releaseTimes.containsKey(sucessorId)) continue;
            int releaseTime = this.temporaryReleaseTimes.get(sucessorId);
            this.releaseTimes.put(sucessorId, releaseTime);
            LogUtil.debug(LOGGER, "set release time of item %s: %s", sucessorId, releaseTime);
        }
    }

    static CausalDependencyState initialize(IDependencyDefinition dependencyDefinition, ReleaseDependencyDefinition releaseDependencyDefinition, boolean syncDependeeStartEnabled) {
        Preconditions.checkNotNull((Object)dependencyDefinition, (Object)"dependency definition must not be null");
        LogUtil.debugCollection(LOGGER, "initialize state\ndependency definition: %s\nbacklog items: %s", dependencyDefinition, dependencyDefinition.getProcessingItems());
        Map<String, Set<String>> directSuccessors = CausalDependencyState.createDirectSuccessorsMap(releaseDependencyDefinition, dependencyDefinition);
        Map<String, Set<String>> openRequiremenIds = CausalDependencyState.createOpenRequirementsMap(releaseDependencyDefinition, dependencyDefinition);
        Map<String, Integer> releaseTimes = CausalDependencyState.createReleaseTimeMap(dependencyDefinition.getProcessingItems(), openRequiremenIds);
        Map<String, Integer> tempReleaseTimes = CausalDependencyState.createTemporaryReleaseTimeMap(dependencyDefinition.getProcessingItems());
        BiMap<String, IProcessingItem> itemMap = RmIdentifiableUtils.createIdMap(dependencyDefinition.getProcessingItems());
        CausalDependencyState instance = new CausalDependencyState(directSuccessors, releaseTimes, openRequiremenIds, tempReleaseTimes, dependencyDefinition, (Map<String, IProcessingItem>)itemMap, syncDependeeStartEnabled);
        LogUtil.debug(LOGGER, "created instance: %s", instance);
        return instance;
    }

    private static Map<String, Integer> createTemporaryReleaseTimeMap(Set<IProcessingItem> backlogItems) {
        HashMap tempReleaseTimes = Maps.newHashMap();
        for (IProcessingItem item : backlogItems) {
            tempReleaseTimes.put(item.getId(), item.getReleaseTime());
        }
        return tempReleaseTimes;
    }

    private static Map<String, Set<String>> createDirectSuccessorsMap(ReleaseDependencyDefinition releaseDependencyDefinition, IDependencyDefinition dependencyDefinition) {
        HashMap directSuccessorsMap = Maps.newHashMap();
        for (IProcessingItem backlogItem : dependencyDefinition.getProcessingItems()) {
            directSuccessorsMap.put(backlogItem.getId(), Sets.newHashSet());
            String predecessorItemEpisodeId = (String)backlogItem.getFixedEpisodeId().orNull();
            if (predecessorItemEpisodeId == null) {
                Set<IProcessingItem> directPredecessors = dependencyDefinition.getDirectDependees(backlogItem);
                Set<String> predecessorIds = RmIdentifiableUtils.getIds(directPredecessors);
                directSuccessorsMap.put(backlogItem.getId(), predecessorIds);
                continue;
            }
            Set<IProcessingItem> directSuccessors = dependencyDefinition.getDirectDependees(backlogItem);
            for (IProcessingItem succ : directSuccessors) {
                String succItemEpisodeId = (String)succ.getFixedEpisodeId().or((Object)"");
                if (releaseDependencyDefinition.isFirstReleaseRequiredBySecond(succItemEpisodeId, predecessorItemEpisodeId)) continue;
                RmUtils.addToKeyedSets(directSuccessorsMap, backlogItem.getId(), succ.getId());
            }
        }
        return directSuccessorsMap;
    }

    private static Map<String, Integer> createReleaseTimeMap(Set<IProcessingItem> items, Map<String, Set<String>> openPreds) {
        HashMap releaseTimeMap = Maps.newHashMap();
        for (IProcessingItem item : items) {
            if (!openPreds.get(item.getId()).isEmpty()) continue;
            releaseTimeMap.put(item.getId(), item.getReleaseTime());
        }
        return releaseTimeMap;
    }

    private static Map<String, Set<String>> createOpenRequirementsMap(ReleaseDependencyDefinition releaseDependencyDefinition, IDependencyDefinition dependencyDefinition) {
        HashMap directPredecessorMap = Maps.newHashMap();
        for (IProcessingItem backlogItem : dependencyDefinition.getProcessingItems()) {
            Set<IProcessingItem> directPredecessors;
            directPredecessorMap.put(backlogItem.getId(), Sets.newHashSet());
            String successorItemEpisodeId = (String)backlogItem.getFixedEpisodeId().orNull();
            if (successorItemEpisodeId == null) {
                directPredecessors = dependencyDefinition.getDirectPrerequisites(backlogItem);
                if (directPredecessors == null || directPredecessors.isEmpty()) continue;
                Set<String> predecessorIds = RmIdentifiableUtils.getIds(directPredecessors);
                directPredecessorMap.put(backlogItem.getId(), predecessorIds);
                continue;
            }
            directPredecessors = dependencyDefinition.getDirectPrerequisites(backlogItem);
            if (directPredecessors == null || directPredecessors.isEmpty()) continue;
            for (IProcessingItem predItem : directPredecessors) {
                String predItemEpisodeId = (String)predItem.getFixedEpisodeId().or((Object)"");
                if (releaseDependencyDefinition.isFirstReleaseRequiredBySecond(successorItemEpisodeId, predItemEpisodeId)) continue;
                RmUtils.addToKeyedSets(directPredecessorMap, backlogItem.getId(), predItem.getId());
            }
        }
        return directPredecessorMap;
    }
}

