/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.EpisodeState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.IEpisodeState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisode;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Set;
import javax.annotation.Nullable;

class FixedDurationEpisodeState
implements IEpisodeState {
    private static final Log LOGGER = Log.with(FixedDurationEpisodeState.class);
    private Integer startTime;
    private Set<String> openStrictlyAssigned;
    private EpisodeState episodeState;
    private final IEpisode episode;

    FixedDurationEpisodeState(Integer startTime, Set<String> openStrictlyAssigned, IEpisode episode, EpisodeState initialState) {
        this.startTime = startTime;
        this.openStrictlyAssigned = openStrictlyAssigned;
        this.episodeState = initialState;
        this.episode = episode;
    }

    @Override
    public void setFailedForItemNewEndTime(String itemId) {
        LogUtil.debug(LOGGER, "finished item %s as failed", itemId);
        this.stateTransition(itemId);
    }

    @Override
    public void setFinishedNewEndTime(String itemId, int end) {
        LogUtil.debug(LOGGER, "finished item %s with end time: %d", itemId, end);
        this.stateTransition(itemId);
    }

    @Override
    public Optional<Integer> getEndTime() {
        return this.episode.getFixedEndTime();
    }

    @Override
    public Optional<Integer> getStartTime() {
        return Optional.fromNullable((Object)this.startTime);
    }

    @Override
    public EpisodeState getState() {
        return this.episodeState;
    }

    @Override
    public IEpisode getEpisode() {
        return this.episode;
    }

    @Override
    public void predecessorHasEndTime(IEpisodeState precedingState) {
        if (this.startTime == null) {
            this.startTime = this.calculateStart(precedingState);
            LogUtil.debug(LOGGER, "set start time of %s to %d", this.episode.getId(), this.startTime);
        }
        this.episodeState = FixedDurationEpisodeState.getState(this.startTime, !this.openStrictlyAssigned.isEmpty());
        LogUtil.debug(LOGGER, "set state of %s to %s", this.episode.getId(), (Object)this.episodeState);
    }

    private void stateTransition(String itemId) {
        this.openStrictlyAssigned.remove(itemId);
        if (this.openStrictlyAssigned.isEmpty()) {
            this.episodeState = EpisodeState.Optionals;
            LogUtil.debug(LOGGER, "set state of %s to %s", this.episode.getId(), (Object)this.episodeState);
        }
    }

    private int calculateStart(IEpisodeState precedingState) {
        if (precedingState.getState().equals((Object)EpisodeState.Empty)) {
            return Math.max(0, (Integer)precedingState.getStartTime().get() + (Integer)this.episode.getStartGap().or((Object)0));
        }
        return Math.max(0, (Integer)precedingState.getEndTime().get() + (Integer)this.episode.getStartGap().or((Object)1));
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("episode", (Object)this.episode.getId()).add("startTime", (Object)this.startTime).add("openStrictlyAssigned", this.openStrictlyAssigned).add("episodeState", (Object)this.episodeState).toString();
    }

    public static IEpisodeState initialize(IEpisode episode, @Nullable Integer start, @Nullable Set<IProcessingItem> assignedItems) {
        Preconditions.checkNotNull((Object)episode, (Object)"episode must not be null");
        LogUtil.debug(LOGGER, "create instance for episode: %s", episode);
        Set<String> items = RmIdentifiableUtils.getIds(assignedItems);
        EpisodeState initialState = FixedDurationEpisodeState.getState(start, !items.isEmpty());
        FixedDurationEpisodeState instance = new FixedDurationEpisodeState(start, items, episode, initialState);
        LogUtil.debug(LOGGER, "created instance: %s", instance);
        return instance;
    }

    private static EpisodeState getState(@Nullable Integer start, boolean itemsAssigned) {
        if (start == null) {
            return EpisodeState.NotStarted;
        }
        if (itemsAssigned) {
            return EpisodeState.Strictly;
        }
        return EpisodeState.Optionals;
    }
}

