/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.DependencyViolation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleViolation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleWarning;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IActivitySetSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IUnstructuredItemSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisode;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

class IterativeSolutionState {
    private final LinkedHashSet<IEpisode> orderedProjectEpisodes = Sets.newLinkedHashSet();
    private final Map<IEpisode, Set<IActivitySetSchedule>> activitySetSchedules = Maps.newHashMap();
    private final Map<IEpisode, Set<IUnstructuredItemSchedule>> itemSchedules = Maps.newHashMap();
    private final Set<IScheduleViolation> violations = Sets.newHashSet();
    private final Set<IScheduleWarning> warnings = Sets.newHashSet();
    private final Set<String> processedItems = Sets.newHashSet();

    IterativeSolutionState() {
    }

    void addIfNotKnown(IEpisode nextEpisode) {
        if (!this.orderedProjectEpisodes.contains(nextEpisode)) {
            this.orderedProjectEpisodes.add(nextEpisode);
        }
    }

    void addActivitySetSchedule(@Nullable IActivitySetSchedule schedule, IEpisode nextEpisode) {
        if (schedule != null) {
            RmUtils.addToKeyedSets(this.activitySetSchedules, nextEpisode, schedule);
            this.warnings.addAll(schedule.getWarnings());
            this.processedItems.add(schedule.getId());
        }
    }

    void addViolations(IScheduleViolation baseViolation, Set<String> dependeeIds) {
        for (String dependeeId : dependeeIds) {
            this.violations.add(new DependencyViolation(dependeeId));
        }
        this.violations.add(baseViolation);
        this.processedItems.add(baseViolation.getId());
        this.processedItems.addAll(dependeeIds);
    }

    void addUnstructuredItemResult(@Nullable IUnstructuredItemSchedule schedule, IEpisode nextEpisode) {
        if (schedule != null) {
            RmUtils.addToKeyedSets(this.itemSchedules, nextEpisode, schedule);
            this.processedItems.add(schedule.getId());
        }
    }

    void addWarning(IScheduleWarning warning, Set<String> dependeeIds) {
        for (String dependeeId : dependeeIds) {
            this.violations.add(new DependencyViolation(dependeeId));
        }
        this.warnings.add(warning);
    }

    LinkedHashSet<IEpisode> getOrderedEpisodes() {
        return this.orderedProjectEpisodes;
    }

    Set<IActivitySetSchedule> getActivitySetSchedules(IEpisode episode) {
        if (!this.activitySetSchedules.containsKey(episode)) {
            return Sets.newHashSet();
        }
        return this.activitySetSchedules.get(episode);
    }

    Set<IUnstructuredItemSchedule> getItemSchedules(IEpisode episode) {
        if (!this.itemSchedules.containsKey(episode)) {
            return Sets.newHashSet();
        }
        return this.itemSchedules.get(episode);
    }

    Set<IScheduleViolation> getViolations() {
        return this.violations;
    }

    Set<IScheduleWarning> getWarnings() {
        return this.warnings;
    }

    int getProcessdItemCount() {
        return this.processedItems.size();
    }

    static IterativeSolutionState createInstance() {
        return new IterativeSolutionState();
    }
}

