/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.FixedSlotDependencyViolationDetector;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.IBacklogState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.IgnoredDependencyViolationDetector;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.IterativeSolutionState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.PrecomputedRoadmapSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.FixedSlotsAssignmentSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.trafo.FixedSprintSolutionTransformer;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.trafo.FixedSprintSolutionTransformerImpl;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleViolation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleWarning;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.problem.IRoadmapProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.EpisodeSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IActivitySetSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IEpisodeSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IRoadmapSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IUnstructuredItemSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisode;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisodeStream;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.ITimePlan;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;

class RoadmapScheduleCreator {
    private final FixedSlotDependencyViolationDetector dependencyViolationDetector = new FixedSlotDependencyViolationDetector();
    private final FixedSprintSolutionTransformer fixedSprintSolutionTransformer = new FixedSprintSolutionTransformerImpl();
    private final IgnoredDependencyViolationDetector ignoredDependencyViolationDetector = new IgnoredDependencyViolationDetector();

    RoadmapScheduleCreator() {
    }

    IRoadmapSchedule createRoadMapSchedule(IRoadmapProblem problem, IterativeSolutionState iterativeSolutionState, IBacklogState backlogState, @Nullable FixedSlotsAssignmentSolution fixedSprintSolution) {
        LinkedHashSet<IEpisodeSchedule> episodeSchedules = this.createEpisodeSchedules(iterativeSolutionState, backlogState, fixedSprintSolution);
        Set<IScheduleWarning> allWarnings = this.getAllWarnings(problem, fixedSprintSolution, episodeSchedules, iterativeSolutionState);
        Set<IScheduleViolation> allViolations = this.getAllViolations(problem, iterativeSolutionState, fixedSprintSolution);
        return PrecomputedRoadmapSchedule.createFromSolution(episodeSchedules, allViolations, allWarnings, this.getAnalysisEndTime(episodeSchedules, problem));
    }

    private Set<IScheduleViolation> getAllViolations(IRoadmapProblem problem, IterativeSolutionState iterativeSolutionState, @Nullable FixedSlotsAssignmentSolution fixedSprintSolution) {
        HashSet violations = Sets.newHashSet(problem.getViolations());
        violations.addAll(iterativeSolutionState.getViolations());
        if (fixedSprintSolution != null) {
            violations.addAll(fixedSprintSolution.getViolations());
        }
        return violations;
    }

    private Set<IScheduleWarning> getAllWarnings(IRoadmapProblem problem, @Nullable FixedSlotsAssignmentSolution fixedSprintSolution, LinkedHashSet<IEpisodeSchedule> episodeSchedules, IterativeSolutionState iterativeSolutionState) {
        HashSet allWarnings = Sets.newHashSet(problem.getWarnings());
        allWarnings.addAll(iterativeSolutionState.getWarnings());
        allWarnings.addAll(this.dependencyViolationDetector.getDependencyViolations(episodeSchedules, problem, fixedSprintSolution));
        allWarnings.addAll(this.ignoredDependencyViolationDetector.getDependencyViolations(episodeSchedules, problem));
        for (IEpisodeSchedule episodeSchedule : episodeSchedules) {
            allWarnings.addAll(episodeSchedule.getWarnings());
        }
        return allWarnings;
    }

    private int getAnalysisEndTime(LinkedHashSet<IEpisodeSchedule> episodeSchedules, IRoadmapProblem problem) {
        int latestScheduleEnd = this.getLatestEnd(episodeSchedules);
        int latestFixedEnd = this.getLatestFixedEnd(problem.getTimePlan());
        return Math.max(latestScheduleEnd, latestFixedEnd);
    }

    private int getLatestFixedEnd(ITimePlan timePlan) {
        int max = Integer.MIN_VALUE;
        for (IEpisodeStream stream : timePlan.getEpisodeStreams()) {
            for (IEpisode episode : stream.getEpisodes()) {
                if (episode.isLaterRelease()) continue;
                max = Math.max(max, (Integer)episode.getFixedEndTime().or((Object)Integer.MIN_VALUE));
            }
        }
        return max;
    }

    private int getLatestEnd(LinkedHashSet<IEpisodeSchedule> episodeSchedules) {
        int max = Integer.MIN_VALUE;
        for (IEpisodeSchedule schedule : episodeSchedules) {
            max = Math.max(max, schedule.getEnd());
        }
        return max;
    }

    private LinkedHashSet<IEpisodeSchedule> createEpisodeSchedules(IterativeSolutionState solutionState, IBacklogState backlogState, FixedSlotsAssignmentSolution fixedSprintState) {
        LinkedHashSet episodeSchedules = Sets.newLinkedHashSet();
        for (IEpisode episode : solutionState.getOrderedEpisodes()) {
            Set<IActivitySetSchedule> episodeActSets = solutionState.getActivitySetSchedules(episode);
            Set<IUnstructuredItemSchedule> episodeItems = solutionState.getItemSchedules(episode);
            IEpisodeSchedule schedule = EpisodeSchedule.createInstance(episode, episodeActSets, episodeItems, (Integer)backlogState.getEpisodeStartTime(episode.getId()).orNull());
            episodeSchedules.add(schedule);
        }
        if (fixedSprintState == null) {
            return episodeSchedules;
        }
        return this.fixedSprintSolutionTransformer.addFixedSlotResults(fixedSprintState, episodeSchedules, backlogState);
    }
}

