/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.calculation.CancellationState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.AbstractActivitySetScheduler;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.ActivitySetScheduleEvaluation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.GroupActivitySetScheduler;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.IActivitySetResourcePoolScheduler;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.IActivitySetScheduleEvaluation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.IActivitySetSchedulingProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.IOptionalActivitySetScheduler;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.TimeLimitedTerminationCondition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.ReachedPlanningHorizonException;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IActivitySetSchedule;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public class OptionalActivitySetScheduler
extends AbstractActivitySetScheduler
implements IOptionalActivitySetScheduler {
    private static final Log LOGGER = Log.with(OptionalActivitySetScheduler.class);

    OptionalActivitySetScheduler(IActivitySetResourcePoolScheduler activitySetResourcePoolScheduler, IActivitySetScheduleEvaluation activitySetScheduleEvaluation) {
        super(activitySetResourcePoolScheduler, activitySetScheduleEvaluation);
    }

    public OptionalActivitySetScheduler(int maxTestAssignmentsPerTeamStage, CancellationState cancellationState) {
        this(new GroupActivitySetScheduler(maxTestAssignmentsPerTeamStage, cancellationState), new ActivitySetScheduleEvaluation());
    }

    @Override
    public Optional<IActivitySetSchedule> scheduleActivitySetWithTimeLimit(IActivitySetSchedulingProblem activitySetProblem) throws ReachedPlanningHorizonException, InterruptedException {
        Preconditions.checkNotNull((Object)activitySetProblem, (Object)"problem must not be null");
        LogUtil.debug(LOGGER, "schedule activity set: %s", activitySetProblem);
        TimeLimitedTerminationCondition terminationCondition = new TimeLimitedTerminationCondition(activitySetProblem.getUpperTimeBound());
        Optional<IActivitySetSchedule> activitySetSchedule = this.scheduleActivitySet(activitySetProblem, terminationCondition);
        if (!activitySetSchedule.isPresent() && activitySetProblem.isUpperTimeBoundPlanningHorizon()) {
            throw new ReachedPlanningHorizonException(activitySetProblem.getId());
        }
        return activitySetSchedule;
    }
}

