/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.MutableResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.FixedSlotWorkAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.util.IWorkAssignable;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.atlassian.rm.jpo.scheduling.util.collection.ImmutableNonEmptyPositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.MutablePositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.RmCollectionUtils;
import com.google.common.base.Optional;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MutableResourceGroup
implements IMutableResourceGroup {
    private final IResourceGroup wrapped;
    private final BiMap<String, IMutableResource> mutableResources;
    private final MutablePositivePrimitivesMap<IMutableResource> freeWork;

    MutableResourceGroup(Set<IMutableResource> mutableResources, IResourceGroup wrapped) {
        this.mutableResources = ImmutableBiMap.copyOf(RmIdentifiableUtils.createIdMap(mutableResources));
        this.freeWork = RmCollectionUtils.newMutablePositiveMap(mutableResources.size());
        this.wrapped = wrapped;
    }

    @Override
    public Set<IMutableResource> getMutableResources() {
        return this.mutableResources.values();
    }

    @Override
    public String getId() {
        return this.wrapped.getId();
    }

    @Override
    public ImmutableNonEmptyPositivePrimitivesMap<IResourceType> getResourceTypeSupply() {
        return this.wrapped.getResourceTypeSupply();
    }

    @Override
    public Set<IResourceType> getResourceTypes() {
        return this.wrapped.getResourceTypes();
    }

    @Override
    public IResourceGroup getDefinition() {
        return this.wrapped;
    }

    @Override
    public Map<IResourceType, Set<IWorkResource>> getTypeToResourceMap() {
        return this.wrapped.getTypeToResourceMap();
    }

    @Override
    public IWorkSlot getNextValidWorkSlotForReleaseTime(int timeStep) {
        return this.wrapped.getNextValidWorkSlotForReleaseTime(timeStep);
    }

    @Override
    public Set<IWorkResource> getResources() {
        return this.wrapped.getResources();
    }

    @Override
    public boolean isStrictStageDivision() {
        return this.wrapped.isStrictStageDivision();
    }

    @Override
    public boolean containsResourceWithId(String resourceId) {
        return this.wrapped.containsResourceWithId(resourceId);
    }

    @Override
    public boolean isFreeWorkSlot(int slotIndex) {
        if (!this.isWorkSlotStrict()) {
            return true;
        }
        for (IMutableResource resource : this.mutableResources.values()) {
            if (!(resource.getAssignedWorkInWorkSlot(slotIndex) > 0.01f)) continue;
            return false;
        }
        return true;
    }

    @Override
    public IWorkSlot getNextWorkSlot(IWorkSlot workSlot) {
        return this.wrapped.getNextWorkSlot(workSlot);
    }

    @Override
    public List<IWorkSlot> getWorkSlotsBetween(int startTime, int endTime) {
        return this.wrapped.getWorkSlotsBetween(startTime, endTime);
    }

    @Override
    public boolean isWorkSlotStrict() {
        return this.wrapped.isWorkSlotStrict();
    }

    @Override
    public MutablePositivePrimitivesMap<IMutableResource> getSchedulableWorkInTimeSlot(int slotIndex) {
        for (IMutableResource resource : this.mutableResources.values()) {
            this.freeWork.put(resource, resource.getUnassignedWorkInWorkSlot(slotIndex));
        }
        return this.freeWork;
    }

    @Override
    public void schedule(Iterable<? extends FixedSlotWorkAssignment> workAssignments) {
        for (FixedSlotWorkAssignment fixedSlotWorkAssignment : workAssignments) {
            String resourceId = fixedSlotWorkAssignment.getResource().getId();
            IMutableResource mutableResource = (IMutableResource)this.mutableResources.get((Object)resourceId);
            int slotIndex = fixedSlotWorkAssignment.getWorkSlot().getIndex();
            float amount = fixedSlotWorkAssignment.getAssignedWorkUnits();
            mutableResource.assignWork(slotIndex, amount);
        }
    }

    @Override
    public void unschedule(Iterable<? extends FixedSlotWorkAssignment> workAssignments) {
        for (FixedSlotWorkAssignment fixedSlotWorkAssignment : workAssignments) {
            String resourceId = fixedSlotWorkAssignment.getResource().getId();
            IMutableResource mutableResource = (IMutableResource)this.mutableResources.get((Object)resourceId);
            int slotIndex = fixedSlotWorkAssignment.getWorkSlot().getIndex();
            float amount = fixedSlotWorkAssignment.getAssignedWorkUnits();
            mutableResource.unassignWork(slotIndex, amount);
        }
    }

    @Override
    public void unscheduleAssignables(Iterable<? extends IWorkAssignable> workAssignables) {
        for (IWorkAssignable iWorkAssignable : workAssignables) {
            this.unschedule(iWorkAssignable.getWorkAssignments());
        }
    }

    @Override
    public Set<IMutableResource> getResourcesWithUnassignedWork(int slotIndex) {
        HashSet resources = Sets.newHashSet();
        for (IMutableResource resource : this.mutableResources.values()) {
            if (!resource.hasUnassignedWorkInWorkSlot(slotIndex)) continue;
            resources.add(resource);
        }
        return resources;
    }

    @Override
    public IWorkSlot getNextWorkSlotWithFullPresence(int timeStep) {
        return this.wrapped.getNextWorkSlotWithFullPresence(timeStep);
    }

    @Override
    public String getSortKey() {
        return this.wrapped.getSortKey();
    }

    @Override
    public IWorkSlot getWorkSlotWithIndex(int slotIndex) {
        return this.wrapped.getWorkSlotWithIndex(slotIndex);
    }

    public String toString() {
        return "MutableResourceGroup [wrapped=" + this.wrapped + "]";
    }

    @Override
    public int getStartTimeStep(int slotIndex) {
        return this.wrapped.getStartTimeStep(slotIndex);
    }

    @Override
    public int getEndTimeStep(int slotIndex) {
        return this.wrapped.getEndTimeStep(slotIndex);
    }

    @Override
    public int getDefaultSlotLength() {
        return this.wrapped.getDefaultSlotLength();
    }

    @Override
    public Optional<IWorkSlot> tryGetWorkSlotWithId(String slotId) {
        return this.wrapped.tryGetWorkSlotWithId(slotId);
    }

    @Override
    public IWorkSlot getSlotOrNextForTimeStep(int timeStep) {
        return this.wrapped.getSlotOrNextForTimeStep(timeStep);
    }

    @Override
    public boolean isRestrictedWorkSlot(int slotIndex) {
        return this.wrapped.isRestrictedWorkSlot(slotIndex);
    }

    public static IMutableResourceGroup createMutableResourceGroup(IResourceGroup group) {
        HashSet resources = Sets.newHashSet();
        Set<IWorkResource> resourceDefinitions = group.getResources();
        for (IWorkResource resourceDefinition : resourceDefinitions) {
            MutableResource mutableREsource = MutableResource.createInstance(resourceDefinition);
            resources.add(mutableREsource);
        }
        MutableResourceGroup instance = new MutableResourceGroup(resources, group);
        return instance;
    }
}

